/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.query.Query;
import ojb.broker.server.Request;
import ojb.broker.server.ServerEntry;
import ojb.broker.server.ServerPool;
import ojb.broker.util.ObjectModification;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class PersistenceBrokerClient
implements PersistenceBroker,
Serializable {
    private static final int invalidId = -1;
    private ServerPool servers;
    private ServerEntry currentServer;
    private int brokerId = -1;

    public PersistenceBrokerClient(ServerPool serverpool) {
        this.servers = serverpool;
        this.currentServer = this.servers.roundRobin();
    }

    private Object callServer(int methodIndex) {
        return this.callServer(methodIndex, this.brokerId, null, null);
    }

    private Object callServer(int methodIndex, Object arg1) {
        return this.callServer(methodIndex, this.brokerId, arg1, null);
    }

    private Object callServer(int methodIndex, Object arg1, Object arg2) {
        return this.callServer(methodIndex, this.brokerId, arg1, arg2);
    }

    private Object callServer(int methodIndex, int brokerid, Object arg1, Object arg2) {
        Socket connection = null;
        try {
            connection = this.currentServer.getConnection();
            OutputStream outstream = connection.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(outstream);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            Request request = new Request(methodIndex, brokerid, arg1, arg2);
            oos.writeObject(request);
            oos.flush();
            outstream.flush();
            InputStream instream = connection.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(instream);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object result = ois.readObject();
            connection.close();
            return result;
        }
        catch (Throwable t) {
            try {
                System.out.println(t.getMessage());
                t.printStackTrace();
                connection.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            System.out.println(t.getMessage());
            return null;
        }
    }

    public void delete(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(4, obj);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result != null) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
    }

    public void store(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(11, obj);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result != null) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
    }

    public void abortTransaction() throws TransactionNotInProgressException {
        Object result = this.callServer(1);
        if (!(result instanceof Integer) || (Integer)result != -1) {
            throw new TransactionNotInProgressException();
        }
        this.brokerId = -1;
    }

    public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        this.currentServer = this.servers.roundRobin();
        Object result = this.callServer(2);
        if (result instanceof Integer) {
            this.brokerId = (Integer)result;
        } else {
            if (result instanceof TransactionInProgressException) {
                throw (TransactionInProgressException)result;
            }
            if (result instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)result;
            }
        }
    }

    public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        Object result = this.callServer(3);
        if (!(result instanceof Integer) || (Integer)result != -1) {
            if (result instanceof TransactionAbortedException) {
                this.brokerId = -1;
                throw (TransactionAbortedException)result;
            }
            this.brokerId = -1;
            throw new TransactionNotInProgressException();
        }
        this.brokerId = -1;
    }

    public Collection getCollectionByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(6, query);
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query) throws PersistenceBrokerException {
        Object result = this.callServer(5, collectionClass, query);
        if (result instanceof ManageableCollection) {
            return (ManageableCollection)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Iterator getIteratorByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(7, query);
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        Object result = this.callServer(8, id);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result instanceof Throwable) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
        return result;
    }

    public Object getObjectByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(9, query);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result instanceof Throwable) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
        return result;
    }

    public Enumeration getPKEnumerationByQuery(Class primaryKeyClass, Query query) throws PersistenceBrokerException {
        Object result = this.callServer(10, primaryKeyClass, query);
        if (result instanceof Enumeration) {
            return (Enumeration)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void store(Object obj, ObjectModification modification) throws PersistenceBrokerException {
        Object result = this.callServer(12, obj, modification);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result != null) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
    }

    public void ping() {
        Object result = this.callServer(9999);
        System.out.println(result.toString());
    }

    public static void main(String[] args) {
        String[] servers = new String[]{"localhost:2001"};
        ServerPool pool = new ServerPool(servers);
        PersistenceBrokerClient pb = new PersistenceBrokerClient(pool);
        int i = 0;
        while (i < 1000) {
            pb.beginTransaction();
            pb.ping();
            pb.commitTransaction();
            ++i;
        }
    }

    public int getUniqueId(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(13, extent, attribute);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public String getUniqueString(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(13, extent, attribute);
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public boolean hasNext(int iteratorId) throws PersistenceBrokerException {
        Object result = this.callServer(14, new Integer(iteratorId));
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new PersistenceBrokerException();
    }

    public Object next(int iteratorId) throws PersistenceBrokerException {
        Object result = this.callServer(15, new Integer(iteratorId));
        if (result instanceof Exception) {
            throw (PersistenceBrokerException)result;
        }
        return result;
    }

    public void releaseDbResources(int iteratorId) {
        Object object = this.callServer(16, new Integer(iteratorId));
    }

    public void removeFromCache(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(17, obj);
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result != null) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
    }
}

