/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class TransformedMap
extends AbstractMapDecorator {
    protected final Transformer keyTransformer;
    protected final Transformer valueTransformer;

    public static Map decorate(Map map, Transformer keyTransformer, Transformer valueTransformer) {
        return new TransformedMap(map, keyTransformer, valueTransformer);
    }

    protected TransformedMap(Map map, Transformer keyTransformer, Transformer valueTransformer) {
        super(map);
        this.keyTransformer = keyTransformer;
        this.valueTransformer = valueTransformer;
    }

    protected Object transformKey(Object object) {
        if (this.keyTransformer == null) {
            return object;
        }
        return this.keyTransformer.transform(object);
    }

    protected Object transformValue(Object object) {
        if (this.valueTransformer == null) {
            return object;
        }
        return this.valueTransformer.transform(object);
    }

    protected Map transformMap(Map map) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.put(this.transformKey(entry.getKey()), this.transformValue(entry.getValue()));
        }
        return result;
    }

    public Object put(Object key, Object value) {
        key = this.transformKey(key);
        value = this.transformValue(value);
        return this.getMap().put(key, value);
    }

    public void putAll(Map mapToCopy) {
        mapToCopy = this.transformMap(mapToCopy);
        this.getMap().putAll(mapToCopy);
    }

    public Set entrySet() {
        if (this.valueTransformer == null) {
            return this.map.entrySet();
        }
        return new TransformedMapEntrySet(this.map.entrySet(), this.valueTransformer);
    }

    static class TransformedMapEntry
    extends AbstractMapEntryDecorator {
        private final Transformer valueTransformer;

        protected TransformedMapEntry(Map.Entry entry, Transformer valueTransformer) {
            super(entry);
            this.valueTransformer = valueTransformer;
        }

        public Object setValue(Object object) {
            if (this.valueTransformer != null) {
                object = this.valueTransformer.transform(object);
            }
            return this.entry.setValue(object);
        }
    }

    static class TransformedMapEntrySetIterator
    extends AbstractIteratorDecorator {
        private final Transformer valueTransformer;

        protected TransformedMapEntrySetIterator(Iterator iterator, Transformer valueTransformer) {
            super(iterator);
            this.valueTransformer = valueTransformer;
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new TransformedMapEntry(entry, this.valueTransformer);
        }
    }

    static class TransformedMapEntrySet
    extends AbstractCollectionDecorator
    implements Set {
        private final Transformer valueTransformer;

        protected TransformedMapEntrySet(Set set, Transformer valueTransformer) {
            super(set);
            this.valueTransformer = valueTransformer;
        }

        public Iterator iterator() {
            return new TransformedMapEntrySetIterator(this.collection.iterator(), this.valueTransformer);
        }

        public Object[] toArray() {
            Object[] array = this.collection.toArray();
            int i = 0;
            while (i < array.length) {
                array[i] = new TransformedMapEntry((Map.Entry)array[i], this.valueTransformer);
                ++i;
            }
            return array;
        }

        public Object[] toArray(Object[] array) {
            Object[] result = array;
            if (array.length > 0) {
                result = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
            }
            result = this.collection.toArray(result);
            int i = 0;
            while (i < result.length) {
                result[i] = new TransformedMapEntry((Map.Entry)result[i], this.valueTransformer);
                ++i;
            }
            if (result.length > array.length) {
                return result;
            }
            System.arraycopy(result, 0, array, 0, result.length);
            if (array.length > result.length) {
                array[result.length] = null;
            }
            return array;
        }
    }
}

