/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.codegen;

import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.DefaultAlertPolicy;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.OutputLanguageVisitor;
import com.google.gxp.compiler.codegen.CodeGenerator;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.cpp.CppCodeGenerator;
import com.google.gxp.compiler.cpp.CppHeaderCodeGenerator;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.java.DynamicImplJavaCodeGenerator;
import com.google.gxp.compiler.java.DynamicStubJavaCodeGenerator;
import com.google.gxp.compiler.java.JavaCodeGenerator;
import com.google.gxp.compiler.js.JavaScriptCodeGenerator;
import com.google.gxp.compiler.xmb.XmbCodeGenerator;
import java.util.Collection;

public class DefaultCodeGeneratorFactory
implements CodeGeneratorFactory {
    private String runtimeMessageSource = null;
    private boolean dynamicModeEnabled = false;
    private Collection<FileRef> sourceFiles = null;
    private Collection<FileRef> schemaFiles = null;
    private Collection<FileRef> sourcePaths = null;
    private AlertPolicy alertPolicy = DefaultAlertPolicy.INSTANCE;
    private final OutputLanguageVisitor<CompilationUnit, CodeGenerator> visitor = new OutputLanguageVisitor<CompilationUnit, CodeGenerator>(){

        @Override
        public CodeGenerator visitCpp(CompilationUnit cUnit) {
            return new CppCodeGenerator(cUnit.getMessageExtractedTree());
        }

        @Override
        public CodeGenerator visitCppHeader(CompilationUnit cUnit) {
            return new CppHeaderCodeGenerator(cUnit.getMessageExtractedTree(), cUnit.getBoundTree().getRequirements());
        }

        @Override
        public CodeGenerator visitJava(CompilationUnit cUnit) {
            if (DefaultCodeGeneratorFactory.this.dynamicModeEnabled) {
                return new DynamicStubJavaCodeGenerator(cUnit.getMessageExtractedTree(), DefaultCodeGeneratorFactory.this.sourceFiles, DefaultCodeGeneratorFactory.this.schemaFiles, DefaultCodeGeneratorFactory.this.sourcePaths, DefaultCodeGeneratorFactory.this.alertPolicy);
            }
            return new JavaCodeGenerator(cUnit.getMessageExtractedTree(), DefaultCodeGeneratorFactory.this.runtimeMessageSource);
        }

        @Override
        public CodeGenerator visitDynamicImplJava(CompilationUnit cUnit) {
            return new DynamicImplJavaCodeGenerator(cUnit.getMessageExtractedTree(), cUnit.getCompilationVersion());
        }

        @Override
        public CodeGenerator visitJavaScript(CompilationUnit cUnit) {
            return new JavaScriptCodeGenerator(cUnit.getMessageExtractedTree());
        }

        @Override
        public CodeGenerator visitXmb(CompilationUnit cUnit) {
            return new XmbCodeGenerator(cUnit.getMessageExtractedTree());
        }
    };

    public String getRuntimeMessageSource() {
        return this.runtimeMessageSource;
    }

    public void setRuntimeMessageSource(String runtimeMessageSource) {
        this.runtimeMessageSource = runtimeMessageSource;
    }

    public boolean isDynamicModeEnabled() {
        return this.dynamicModeEnabled;
    }

    public void setDynamicModeEnabled(boolean dynamicModeEnabled) {
        this.dynamicModeEnabled = dynamicModeEnabled;
    }

    public void setSourceFiles(Collection<FileRef> sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public void setSchemaFiles(Collection<FileRef> schemaFiles) {
        this.schemaFiles = schemaFiles;
    }

    public void setSourcePaths(Collection<FileRef> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setAlertPolicy(AlertPolicy alertPolicy) {
        this.alertPolicy = alertPolicy;
    }

    @Override
    public CodeGenerator getCodeGenerator(OutputLanguage outputLanguage, CompilationUnit compilationUnit) {
        return outputLanguage.acceptVisitor(this.visitor, compilationUnit);
    }
}

