/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.InvalidAttributeValueError;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.Map;

public class BundleType
extends Type {
    private final Schema schema;
    private final ImmutableMap<String, AttributeValidator> attrMap;

    public BundleType(SourcePosition pos, String displayName, Schema schema, Map<String, AttributeValidator> attrMap) {
        super(pos, displayName);
        this.schema = Preconditions.checkNotNull(schema);
        this.attrMap = ImmutableMap.copyOf(attrMap);
    }

    public BundleType(Node fromNode, Schema schema, Map<String, AttributeValidator> attrMap) {
        super(fromNode);
        this.schema = Preconditions.checkNotNull(schema);
        this.attrMap = ImmutableMap.copyOf(attrMap);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, AttributeValidator> getAttrMap() {
        return this.attrMap;
    }

    public AttributeValidator getValidator(String attr) {
        return this.attrMap.get(attr);
    }

    @Override
    public boolean takesDefaultParam() {
        return false;
    }

    @Override
    public boolean onlyAllowedInParam() {
        return true;
    }

    @Override
    public Expression parseObjectConstant(String paramName, ObjectConstant oc, AlertSink alertSink) {
        AttributeValidator validator = this.getValidator(paramName);
        if (!validator.isValidValue(oc.getValue())) {
            alertSink.add(new InvalidAttributeValueError(oc));
        }
        return validator.isFlagSet(AttributeValidator.Flag.BOOLEAN) ? new BooleanConstant((Node)oc, true) : new StringConstant(oc, null, oc.getValue());
    }

    @Override
    public <T> T acceptTypeVisitor(TypeVisitor<T> visitor) {
        return visitor.visitBundleType(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AttributeBundle(");
        Join.join(sb, ", ", this.attrMap.keySet());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean matches(Type that) {
        if (that instanceof BundleType) {
            BundleType thatBundle = (BundleType)that;
            return Objects.equal(this.getSchema(), thatBundle.getSchema()) && Objects.equal(this.getAttrMap(), thatBundle.getAttrMap());
        }
        return false;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof BundleType && this.equals((BundleType)that);
    }

    public boolean equals(BundleType that) {
        return this.equalsType(that) && Objects.equal(this.getSchema(), that.getSchema()) && Objects.equal(this.getAttrMap(), that.getAttrMap());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.typeHashCode(), this.getSchema(), this.getAttrMap());
    }
}

