/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StubWebApplicationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.pattern.PathPatternParser;

public class StandaloneMockMvcBuilder
extends AbstractMockMvcBuilder<StandaloneMockMvcBuilder> {
    private final List<Object> controllers;
    @Nullable
    private List<Object> controllerAdvice;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();
    @Nullable
    private Validator validator;
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private FormattingConversionService conversionService;
    @Nullable
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    @Nullable
    private Long asyncRequestTimeout;
    @Nullable
    private List<ViewResolver> viewResolvers;
    private LocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    @Nullable
    private FlashMapManager flashMapManager;
    @Nullable
    private PathPatternParser patternParser;
    private boolean useSuffixPatternMatch = false;
    private boolean useTrailingSlashPatternMatch = true;
    @Nullable
    private Boolean removeSemicolonContent;
    private Map<String, String> placeholderValues = new HashMap<String, String>();
    private Supplier<RequestMappingHandlerMapping> handlerMappingFactory = RequestMappingHandlerMapping::new;

    protected StandaloneMockMvcBuilder(Object ... controllers) {
        this.controllers = StandaloneMockMvcBuilder.instantiateIfNecessary(controllers);
    }

    private static List<Object> instantiateIfNecessary(Object[] specified) {
        ArrayList<Object> instances = new ArrayList<Object>(specified.length);
        for (Object obj : specified) {
            instances.add(obj instanceof Class ? BeanUtils.instantiateClass((Class)((Class)obj)) : obj);
        }
        return instances;
    }

    public StandaloneMockMvcBuilder setControllerAdvice(Object ... controllerAdvice) {
        this.controllerAdvice = StandaloneMockMvcBuilder.instantiateIfNecessary(controllerAdvice);
        return this;
    }

    public StandaloneMockMvcBuilder setMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        this.messageConverters = Arrays.asList(messageConverters);
        return this;
    }

    public StandaloneMockMvcBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public StandaloneMockMvcBuilder setConversionService(FormattingConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public StandaloneMockMvcBuilder addInterceptors(HandlerInterceptor ... interceptors) {
        this.addMappedInterceptors(null, interceptors);
        return this;
    }

    public StandaloneMockMvcBuilder addMappedInterceptors(@Nullable String[] pathPatterns, HandlerInterceptor ... interceptors) {
        for (HandlerInterceptor interceptor : interceptors) {
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, null, interceptor));
        }
        return this;
    }

    public StandaloneMockMvcBuilder setContentNegotiationManager(ContentNegotiationManager manager) {
        this.contentNegotiationManager = manager;
        return this;
    }

    public StandaloneMockMvcBuilder setAsyncRequestTimeout(long timeout) {
        this.asyncRequestTimeout = timeout;
        return this;
    }

    public StandaloneMockMvcBuilder setCustomArgumentResolvers(HandlerMethodArgumentResolver ... argumentResolvers) {
        this.customArgumentResolvers = Arrays.asList(argumentResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomReturnValueHandlers(HandlerMethodReturnValueHandler ... handlers) {
        this.customReturnValueHandlers = Arrays.asList(handlers);
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        this.handlerExceptionResolvers = exceptionResolvers;
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
        this.handlerExceptionResolvers = Arrays.asList(exceptionResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setViewResolvers(ViewResolver ... resolvers) {
        this.viewResolvers = Arrays.asList(resolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setSingleView(View view) {
        this.viewResolvers = Collections.singletonList(new StaticViewResolver(view));
        return this;
    }

    public StandaloneMockMvcBuilder setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public StandaloneMockMvcBuilder setFlashMapManager(FlashMapManager flashMapManager) {
        this.flashMapManager = flashMapManager;
        return this;
    }

    public void setPatternParser(PathPatternParser parser) {
        this.patternParser = parser;
    }

    @Deprecated
    public StandaloneMockMvcBuilder setUseSuffixPatternMatch(boolean useSuffixPatternMatch) {
        this.useSuffixPatternMatch = useSuffixPatternMatch;
        return this;
    }

    public StandaloneMockMvcBuilder setUseTrailingSlashPatternMatch(boolean useTrailingSlashPatternMatch) {
        this.useTrailingSlashPatternMatch = useTrailingSlashPatternMatch;
        return this;
    }

    public StandaloneMockMvcBuilder setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
        return this;
    }

    public StandaloneMockMvcBuilder addPlaceholderValue(String name, String value) {
        this.placeholderValues.put(name, value);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomHandlerMapping(Supplier<RequestMappingHandlerMapping> factory) {
        this.handlerMappingFactory = factory;
        return this;
    }

    @Override
    protected WebApplicationContext initWebAppContext() {
        MockServletContext servletContext = new MockServletContext();
        StubWebApplicationContext wac = new StubWebApplicationContext(servletContext);
        this.registerMvcSingletons(wac);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, wac);
        return wac;
    }

    private void registerMvcSingletons(StubWebApplicationContext wac) {
        StandaloneConfiguration config = new StandaloneConfiguration();
        config.setApplicationContext((ApplicationContext)wac);
        ServletContext sc = wac.getServletContext();
        wac.addBeans(this.controllers);
        wac.addBeans(this.controllerAdvice);
        FormattingConversionService mvcConversionService = config.mvcConversionService();
        wac.addBean("mvcConversionService", mvcConversionService);
        ResourceUrlProvider resourceUrlProvider = config.mvcResourceUrlProvider();
        wac.addBean("mvcResourceUrlProvider", resourceUrlProvider);
        ContentNegotiationManager mvcContentNegotiationManager = config.mvcContentNegotiationManager();
        wac.addBean("mvcContentNegotiationManager", mvcContentNegotiationManager);
        Validator mvcValidator = config.mvcValidator();
        wac.addBean("mvcValidator", mvcValidator);
        RequestMappingHandlerMapping hm = config.getHandlerMapping(mvcConversionService, resourceUrlProvider);
        if (sc != null) {
            hm.setServletContext(sc);
        }
        hm.setApplicationContext((ApplicationContext)wac);
        hm.afterPropertiesSet();
        wac.addBean("requestMappingHandlerMapping", hm);
        RequestMappingHandlerAdapter ha = config.requestMappingHandlerAdapter(mvcContentNegotiationManager, mvcConversionService, mvcValidator);
        if (sc != null) {
            ha.setServletContext(sc);
        }
        ha.setApplicationContext((ApplicationContext)wac);
        ha.afterPropertiesSet();
        wac.addBean("requestMappingHandlerAdapter", ha);
        wac.addBean("handlerExceptionResolver", config.handlerExceptionResolver(mvcContentNegotiationManager));
        wac.addBeans(this.initViewResolvers(wac));
        wac.addBean("localeResolver", this.localeResolver);
        wac.addBean("themeResolver", new FixedThemeResolver());
        wac.addBean("viewNameTranslator", new DefaultRequestToViewNameTranslator());
        this.flashMapManager = new SessionFlashMapManager();
        wac.addBean("flashMapManager", this.flashMapManager);
        this.extendMvcSingletons(sc).forEach(wac::addBean);
    }

    private List<ViewResolver> initViewResolvers(WebApplicationContext wac) {
        this.viewResolvers = this.viewResolvers != null ? this.viewResolvers : Collections.singletonList(new InternalResourceViewResolver());
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof WebApplicationObjectSupport)) continue;
            ((WebApplicationObjectSupport)viewResolver).setApplicationContext((ApplicationContext)wac);
        }
        return this.viewResolvers;
    }

    protected Map<String, Object> extendMvcSingletons(@Nullable ServletContext servletContext) {
        return Collections.emptyMap();
    }

    private static class StaticViewResolver
    implements ViewResolver {
        private final View view;

        public StaticViewResolver(View view) {
            this.view = view;
        }

        @Nullable
        public View resolveViewName(String viewName, Locale locale) {
            return this.view;
        }
    }

    private static class StaticStringValueResolver
    implements StringValueResolver {
        private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", false);
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver = values::get;

        public StaticStringValueResolver(Map<String, String> values) {
        }

        public String resolveStringValue(String strVal) throws BeansException {
            return this.helper.replacePlaceholders(strVal, this.resolver);
        }
    }

    private class StandaloneConfiguration
    extends WebMvcConfigurationSupport {
        private StandaloneConfiguration() {
        }

        public RequestMappingHandlerMapping getHandlerMapping(FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
            RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)StandaloneMockMvcBuilder.this.handlerMappingFactory.get();
            handlerMapping.setEmbeddedValueResolver((StringValueResolver)new StaticStringValueResolver(StandaloneMockMvcBuilder.this.placeholderValues));
            if (StandaloneMockMvcBuilder.this.patternParser != null) {
                handlerMapping.setPatternParser(StandaloneMockMvcBuilder.this.patternParser);
            } else {
                handlerMapping.setUseSuffixPatternMatch(StandaloneMockMvcBuilder.this.useSuffixPatternMatch);
                if (StandaloneMockMvcBuilder.this.removeSemicolonContent != null) {
                    handlerMapping.setRemoveSemicolonContent(StandaloneMockMvcBuilder.this.removeSemicolonContent.booleanValue());
                }
            }
            handlerMapping.setUseTrailingSlashMatch(StandaloneMockMvcBuilder.this.useTrailingSlashPatternMatch);
            handlerMapping.setOrder(0);
            handlerMapping.setInterceptors(this.getInterceptors(mvcConversionService, mvcResourceUrlProvider));
            return handlerMapping;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(StandaloneMockMvcBuilder.this.messageConverters);
        }

        protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.addAll(StandaloneMockMvcBuilder.this.customArgumentResolvers);
        }

        protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
            returnValueHandlers.addAll(StandaloneMockMvcBuilder.this.customReturnValueHandlers);
        }

        protected void addInterceptors(InterceptorRegistry registry) {
            for (MappedInterceptor interceptor : StandaloneMockMvcBuilder.this.mappedInterceptors) {
                InterceptorRegistration registration = registry.addInterceptor(interceptor.getInterceptor());
                if (interceptor.getPathPatterns() == null) continue;
                registration.addPathPatterns(interceptor.getPathPatterns());
            }
        }

        public ContentNegotiationManager mvcContentNegotiationManager() {
            return StandaloneMockMvcBuilder.this.contentNegotiationManager != null ? StandaloneMockMvcBuilder.this.contentNegotiationManager : super.mvcContentNegotiationManager();
        }

        public FormattingConversionService mvcConversionService() {
            return StandaloneMockMvcBuilder.this.conversionService != null ? StandaloneMockMvcBuilder.this.conversionService : super.mvcConversionService();
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            if (StandaloneMockMvcBuilder.this.asyncRequestTimeout != null) {
                configurer.setDefaultTimeout(StandaloneMockMvcBuilder.this.asyncRequestTimeout.longValue());
            }
        }

        public Validator mvcValidator() {
            Validator mvcValidator;
            Validator validator = mvcValidator = StandaloneMockMvcBuilder.this.validator != null ? StandaloneMockMvcBuilder.this.validator : super.mvcValidator();
            if (mvcValidator instanceof InitializingBean) {
                try {
                    ((InitializingBean)mvcValidator).afterPropertiesSet();
                }
                catch (Exception ex) {
                    throw new BeanInitializationException("Failed to initialize Validator", (Throwable)ex);
                }
            }
            return mvcValidator;
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            if (StandaloneMockMvcBuilder.this.handlerExceptionResolvers == null) {
                return;
            }
            for (HandlerExceptionResolver resolver : StandaloneMockMvcBuilder.this.handlerExceptionResolvers) {
                ApplicationContext applicationContext;
                if (resolver instanceof ApplicationContextAware && (applicationContext = this.getApplicationContext()) != null) {
                    ((ApplicationContextAware)resolver).setApplicationContext(applicationContext);
                }
                if (resolver instanceof InitializingBean) {
                    try {
                        ((InitializingBean)resolver).afterPropertiesSet();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failure from afterPropertiesSet", ex);
                    }
                }
                exceptionResolvers.add(resolver);
            }
        }
    }
}

