/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jasper.runtime;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts2.jasper.runtime.TagHandlerPool;

public class PerThreadTagHandlerPool
extends TagHandlerPool {
    private int maxSize;
    private Vector perThreadDataVector = new Vector();
    private ThreadLocal perThread;

    @Override
    protected void init(ServletConfig config) {
        this.maxSize = 5;
        String maxSizeS = PerThreadTagHandlerPool.getOption(config, OPTION_MAXSIZE, null);
        if (maxSizeS != null) {
            this.maxSize = Integer.parseInt(maxSizeS);
            if (this.maxSize < 0) {
                this.maxSize = 5;
            }
        }
        this.perThread = new ThreadLocal(){

            protected Object initialValue() {
                PerThreadData ptd = new PerThreadData();
                ptd.handlers = new Tag[PerThreadTagHandlerPool.this.maxSize];
                ptd.current = -1;
                PerThreadTagHandlerPool.this.perThreadDataVector.addElement(ptd);
                return ptd;
            }
        };
    }

    @Override
    public Tag get(Class handlerClass) throws JspException {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd.current >= 0) {
            return ptd.handlers[ptd.current--];
        }
        try {
            return (Tag)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reuse(Tag handler) {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd.current < ptd.handlers.length - 1) {
            ptd.handlers[++ptd.current] = handler;
        } else {
            handler.release();
        }
    }

    @Override
    public void release() {
        Enumeration enumeration = this.perThreadDataVector.elements();
        while (enumeration.hasMoreElements()) {
            PerThreadData ptd = (PerThreadData)enumeration.nextElement();
            if (ptd.handlers == null) continue;
            for (int i = ptd.current; i >= 0; --i) {
                if (ptd.handlers[i] == null) continue;
                ptd.handlers[i].release();
            }
        }
    }

    private static class PerThreadData {
        Tag[] handlers;
        int current;

        private PerThreadData() {
        }
    }
}

