/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cache

import "github.com/apache/servicecomb-service-center/pkg/util"

type Node struct {
	// user data
	Cache *Cache
	// tree will set the value below after the node added in.
	Name   string
	Tree   *Tree
	Childs *util.ConcurrentMap
	Level  int
}

func (n *Node) ChildNodes() (nodes []*Node) {
	n.Childs.ForEach(func(item util.MapItem) (next bool) {
		nodes = append(nodes, item.Value.(*Node))
		return true
	})
	return
}

func NewNode() *Node {
	return &Node{
		Cache:  NewCache(),
		Childs: util.NewConcurrentMap(0),
	}
}
