/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.RulePredicate;
import org.apache.qpid.server.security.access.config.predicates.RulePredicateBuilder;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.apache.qpid.server.security.access.util.PrefixTreeSet;
import org.apache.qpid.server.security.access.util.WildCardSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AclRulePredicatesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclRulePredicatesBuilder.class);
    private static final AclRulePredicates EMPTY = new AclRulePredicates();
    public static final String WILD_CARD = "*";
    public static final int WILD_CARD_LENGTH = "*".length();
    private final Map<Property, Set<?>> _parsedProperties = new EnumMap(Property.class);
    private final Set<String> _hostNames = new HashSet<String>();
    private final Set<String> _networks = new HashSet<String>();
    private final Set<String> _attributeNames = new HashSet<String>();

    public AclRulePredicatesBuilder(Map<Property, ?> values) {
        this();
        if (values != null) {
            for (Map.Entry<Property, ?> entry : values.entrySet()) {
                this.addPropertyValues(entry.getKey(), entry.getValue());
            }
        }
    }

    public AclRulePredicatesBuilder() {
        for (Property property : Property.values()) {
            if (property == Property.FROM_HOSTNAME) {
                this._parsedProperties.put(property, this._hostNames);
                continue;
            }
            if (property == Property.FROM_NETWORK) {
                this._parsedProperties.put(property, this._networks);
                continue;
            }
            if (property == Property.ATTRIBUTES) {
                this._parsedProperties.put(property, this._attributeNames);
                continue;
            }
            if (Property.isBooleanType(property)) {
                this._parsedProperties.put(property, new HashSet());
                continue;
            }
            this._parsedProperties.put(property, new PrefixTreeSet());
        }
    }

    public AclRulePredicates build() {
        return this._parsedProperties.isEmpty() ? EMPTY : new AclRulePredicates(this);
    }

    public AclRulePredicates build(FirewallRuleFactory firewallRuleFactory) {
        return this._parsedProperties.isEmpty() ? EMPTY : new AclRulePredicates(firewallRuleFactory, this);
    }

    public AclRulePredicatesBuilder parse(String key, String value) {
        Property property = Property.parse(key);
        if (this.addPropertyValue(property, value)) {
            LOGGER.debug("Parsed '{}' with value '{}'", (Object)property, (Object)value);
        }
        return this;
    }

    public AclRulePredicatesBuilder parse(String key, Set<String> values) {
        Property property = Property.parse(key);
        for (String value : values) {
            if (!this.addPropertyValue(property, value)) continue;
            LOGGER.debug("Parsed {} with value {}", (Object)property, (Object)value);
        }
        return this;
    }

    public AclRulePredicatesBuilder put(Property property, String value) {
        this.addPropertyValue(property, value);
        return this;
    }

    private void addPropertyValues(Property property, Object value) {
        if (value instanceof Collection) {
            for (Object v : (Collection)value) {
                this.addPropertyValues(property, v);
            }
        } else {
            this.addPropertyValue(property, Objects.toString(value, null));
        }
    }

    private boolean addPropertyValue(Property property, String value) {
        if (property == Property.FROM_HOSTNAME) {
            this.checkFirewallRule(property, value, Property.FROM_NETWORK);
            this._hostNames.addAll(this.splitToSet(value));
        } else if (property == Property.FROM_NETWORK) {
            this.checkFirewallRule(property, value, Property.FROM_HOSTNAME);
            this._networks.addAll(this.splitToSet(value));
        } else if (property == Property.ATTRIBUTES) {
            this._attributeNames.addAll(this.splitToSet(value));
        } else {
            if (property == Property.CONNECTION_LIMIT) {
                LOGGER.warn("The ACL Rule property 'connection_limit' was removed and it is not supported anymore");
                return false;
            }
            if (property == Property.CONNECTION_FREQUENCY_LIMIT) {
                LOGGER.warn("The ACL Rule property 'connection_frequency_limit' was removed and it is not supported anymore");
                return false;
            }
            this.addPropertyValueImpl(property, value);
        }
        return true;
    }

    private void addPropertyValueImpl(Property property, String value) {
        if (value == null) {
            this._parsedProperties.put(property, WildCardSet.newSet());
            return;
        }
        if ((value = value.trim()).isEmpty() || WILD_CARD.equals(value)) {
            this._parsedProperties.put(property, WildCardSet.newSet());
            return;
        }
        Set<?> values = this._parsedProperties.get((Object)property);
        if (Property.isBooleanType(property)) {
            values.add(this.parseBoolean(value));
        } else if (values instanceof PrefixTreeSet) {
            ((PrefixTreeSet)values).add(value);
        } else {
            values.add(value);
        }
    }

    private Boolean parseBoolean(String value) {
        if (value.endsWith(WILD_CARD)) {
            String prefix = value.substring(0, value.length() - WILD_CARD_LENGTH).toLowerCase(Locale.ENGLISH);
            if (Boolean.TRUE.toString().startsWith(prefix)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().startsWith(prefix)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Unknown boolean value: " + value);
        }
        return Boolean.parseBoolean(value);
    }

    private Set<String> splitToSet(String value) {
        if (value == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(value.split(",")));
    }

    private void checkFirewallRule(Property property, String value, Property exclusiveProperty) {
        if (!this._parsedProperties.get((Object)exclusiveProperty).isEmpty()) {
            throw new IllegalStateException(String.format("Cannot parse '%s=%s' because property '%s' has already been defined", new Object[]{property.toString().toLowerCase(Locale.ENGLISH), value, exclusiveProperty}));
        }
    }

    Map<Property, Set<Object>> newProperties() {
        EnumMap<Property, Set<Object>> properties = new EnumMap<Property, Set<Object>>(Property.class);
        for (Map.Entry<Property, Set<?>> entry : this._parsedProperties.entrySet()) {
            Set<?> values = entry.getValue();
            if (values.isEmpty()) continue;
            properties.put(entry.getKey(), Collections.unmodifiableSet(values));
        }
        return properties;
    }

    RulePredicate newRulePredicate() {
        return new RulePredicateBuilder().build(this._parsedProperties);
    }

    RulePredicate newRulePredicate(FirewallRuleFactory factory) {
        return new RulePredicateBuilder(factory).build(this._parsedProperties);
    }
}

