/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.util.UUID;
import org.apache.qpid.server.store.berkeleydb.entry.HierarchyKey;

public class HierarchyKeyBinding
extends TupleBinding<HierarchyKey> {
    private static final HierarchyKeyBinding INSTANCE = new HierarchyKeyBinding();

    public static HierarchyKeyBinding getInstance() {
        return INSTANCE;
    }

    private HierarchyKeyBinding() {
    }

    public HierarchyKey entryToObject(TupleInput tupleInput) {
        UUID childId = new UUID(tupleInput.readLong(), tupleInput.readLong());
        String parentType = tupleInput.readString();
        return new HierarchyKey(childId, parentType);
    }

    public void objectToEntry(HierarchyKey hk, TupleOutput tupleOutput) {
        UUID uuid = hk.getChildId();
        tupleOutput.writeLong(uuid.getMostSignificantBits());
        tupleOutput.writeLong(uuid.getLeastSignificantBits());
        tupleOutput.writeString(hk.getParentType());
    }
}

