/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *******************************************************************************/
package org.apache.ofbiz.order.order.test

import org.apache.ofbiz.service.ServiceUtil
import org.apache.ofbiz.service.testtools.OFBizTestCase

class CustRequestPermissionCheckTests extends OFBizTestCase {

    CustRequestPermissionCheckTests(String name) {
        super(name)
    }

    void testCustRequestPermission() {
        Map serviceCtx = [:]
        serviceCtx.fromPartyId = 'Company'
        serviceCtx.mainAction = 'TEST'
        serviceCtx.userLogin = userLogin
        Map result = dispatcher.runSync('custRequestPermissionCheck', serviceCtx)
        assert ServiceUtil.isSuccess(result)
    }

}
