/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandButton;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CommandLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;

public class CommandButtonRenderer
extends CommandLinkRenderer {
    private PropertyKey _iconKey;
    private static final List<String> _DISABLED_STATE_LIST = Collections.singletonList("p_AFDisabled");

    public CommandButtonRenderer() {
        this(CoreCommandButton.TYPE);
    }

    protected CommandButtonRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._iconKey = type.findKey("icon");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        String clientId = this.getClientId(context, component);
        if (this.canSkipRendering(rc, clientId)) {
            return;
        }
        if (this.getPartialSubmit(component, bean)) {
            AutoSubmitUtils.writeDependencies(context, rc);
        }
        assert (rc.getCurrentClientId() == null);
        rc.setCurrentClientId(clientId);
        ResponseWriter rw = context.getResponseWriter();
        String icon = this.getIcon(component, bean);
        if (icon != null && !CommandButtonRenderer._supportsOnClickOnImgInput(rc)) {
            if (!this.getDisabled(component, bean)) {
                rw.startElement("a", component);
                this.renderEncodedActionURI(context, "href", "#");
                rw.writeAttribute("onclick", (Object)this.getOnclick(component, bean), null);
                rw.startElement("img", component);
                this.renderAllAttributes(context, rc, component, bean);
                this.renderEncodedResourceURI(context, "src", icon);
                rw.endElement("img");
                rw.endElement("a");
            } else {
                rw.startElement("img", component);
                this.renderAllAttributes(context, rc, component, bean);
                this.renderEncodedResourceURI(context, "src", icon);
                rw.endElement("img");
            }
        } else {
            char accessKey;
            boolean useButtonTag = this.useButtonTags(rc);
            String element = useButtonTag ? "button" : "input";
            rw.startElement(element, component);
            this.renderId(context, component);
            String text = this.getText(component, bean);
            if (useButtonTag) {
                rw.writeAttribute("type", (Object)this.getButtonType(), null);
            } else if (icon != null) {
                rw.writeAttribute("type", (Object)"image", null);
            } else {
                rw.writeAttribute("type", (Object)this.getInputType(), null);
            }
            if (this.getDisabled(component, bean)) {
                rw.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
                this.renderStyleAttributes(context, rc, component, bean);
            } else {
                this.renderAllAttributes(context, rc, component, bean);
            }
            if (CommandButtonRenderer.supportsAccessKeys(rc)) {
                accessKey = this.getAccessKey(component, bean);
                if (accessKey != '\uffff') {
                    rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
                }
            } else {
                accessKey = '\uffff';
            }
            if (useButtonTag) {
                AccessKeyUtils.renderAccessKeyText(context, (Object)text, accessKey, "AFAccessKeyStyle");
                if (icon != null) {
                    OutputUtils.renderImage(context, rc, icon, null, null, null, this.getShortDesc(component, bean));
                }
            } else {
                if (!CommandButtonRenderer.supportsScripting(rc)) {
                    String encodingKey = icon != null ? "_inputImagekey" : "_parameterkey";
                    rw.writeAttribute("name", (Object)("source" + encodingKey + clientId), null);
                }
                if (icon != null) {
                    this.renderEncodedResourceURI(context, "src", icon);
                } else {
                    rw.writeAttribute("value", (Object)text, "text");
                }
            }
            rw.endElement(element);
        }
        rc.setCurrentClientId(null);
    }

    protected String getButtonType() {
        return "button";
    }

    protected String getInputType() {
        return "submit";
    }

    protected boolean useButtonTags(RenderingContext arc) {
        return CommandButtonRenderer.supportsScripting(arc) && CommandButtonRenderer.supportsAdvancedForms(arc) && CommandButtonRenderer.supportsIntrinsicEvents(arc);
    }

    protected List<String> getStateStyleClasses(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        if (this.getDisabled(component, bean)) {
            return _DISABLED_STATE_LIST;
        }
        return null;
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String defaultStyleClass) throws IOException {
        String styleClass = this.getStyleClass(component, bean);
        List<String> stateStyleClasses = this.getStateStyleClasses(context, rc, component, bean);
        if (styleClass == null && defaultStyleClass != null && stateStyleClasses == null) {
            CommandButtonRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)defaultStyleClass);
        } else {
            int numStates;
            List<String> parsedStyleClasses = OutputUtils.parseStyleClassList(styleClass);
            int userStyleClassCount = parsedStyleClasses == null ? (styleClass == null ? 0 : 1) : parsedStyleClasses.size();
            int numClasses = userStyleClassCount + (defaultStyleClass != null ? 1 : 0) + (numStates = stateStyleClasses != null ? stateStyleClasses.size() : 0);
            if (numClasses > 0) {
                int i;
                String[] styleClasses = new String[numClasses];
                if (parsedStyleClasses != null) {
                    for (i = 0; i < userStyleClassCount; ++i) {
                        styleClasses[i] = parsedStyleClasses.get(i);
                    }
                } else if (styleClass != null) {
                    styleClasses[i++] = styleClass;
                }
                if (defaultStyleClass != null) {
                    styleClasses[i++] = defaultStyleClass;
                }
                int j = 0;
                while (j < numStates) {
                    styleClasses[i] = stateStyleClasses.get(j);
                    ++j;
                    ++i;
                }
                CommandButtonRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])styleClasses);
            }
        }
        String style = this.getInlineStyle(component, bean);
        if (style != null) {
            context.getResponseWriter().writeAttribute("style", (Object)style, "inlineStyle");
        }
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|commandButton";
    }

    protected String getIcon(UIComponent component, FacesBean bean) {
        return CommandButtonRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }

    @Override
    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeURIAttribute("id", (Object)clientId, "id");
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (CommandButtonRenderer.supportsScripting(arc)) {
                context.getResponseWriter().writeURIAttribute("name", (Object)clientId, "id");
            }
        }
    }

    private static boolean _supportsOnClickOnImgInput(RenderingContext rc) {
        Object cap = rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_ONCLICK_IMG_INPUT);
        return !Boolean.FALSE.equals(cap);
    }
}

