/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.painter.AbstractWrappingPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ImageUtils;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContextProxy;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;

public class OffscreenWrappingPainter
extends AbstractWrappingPainter
implements ImageObserver {
    private static final int _MAX_BUFFER_AREA = 24000;

    public OffscreenWrappingPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        BufferedImage buffer = this._createOffscreenBuffer(context, width, height + 1);
        if (buffer == null) {
            super.paint(context, g, x, y, width, height);
            return;
        }
        Graphics offscreenG = this._getInitializedGraphics(context, buffer);
        offscreenG.setColor(context.getPaintBackground());
        offscreenG.fillRect(0, 0, width, height + 1);
        offscreenG.setColor(g.getColor());
        offscreenG.translate(-x, -y);
        super.paint(context, offscreenG, x, y + 1, width, height);
        Image transparentImage = ImageUtils.createFilteredImage(buffer, new TransparencyFilter());
        ImageUtils.loadImage(transparentImage);
        g.drawImage(transparentImage, x, y, x + width, y + height, 0, 1, width, height + 1, this);
        offscreenG.dispose();
        transparentImage.flush();
        buffer.flush();
    }

    public Dimension getPreferredSize(PaintContext context) {
        Dimension size = null;
        BufferedImage buffer = this._createOffscreenBuffer(context, 1, 1);
        if (buffer != null) {
            Graphics g = this._getInitializedGraphics(context, buffer);
            size = super.getPreferredSize(new ProxyContext(context, g));
            g.dispose();
            buffer.flush();
        } else {
            size = super.getPreferredSize(context);
        }
        return size;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0xA0) == 0;
    }

    private BufferedImage _createOffscreenBuffer(PaintContext context, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        if (width * height > 24000) {
            assert (false);
            return null;
        }
        int type = 2;
        if (this._isTextAntialiased(context) && (context.getPaintFont().getStyle() & 1) != 0) {
            type = 6;
        }
        return new BufferedImage(width, height, type);
    }

    private Graphics _getInitializedGraphics(PaintContext context, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        g.setFont(context.getPaintFont());
        if (this._isTextAntialiased(context)) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (image.getType() == 6) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return g;
    }

    private boolean _isTextAntialiased(PaintContext context) {
        return Boolean.TRUE.equals(context.getPaintData(ImageConstants.TEXT_ANTIALIAS_KEY));
    }

    private static class TransparencyFilter
    extends RGBImageFilter {
        private int _rgb;
        private boolean _gotRGB;

        public TransparencyFilter() {
            this.canFilterIndexColorModel = false;
        }

        public int filterRGB(int x, int y, int rgb) {
            if (y != 0 && !this._gotRGB) {
                assert (this._gotRGB);
                if (y != 0) {
                    throw new IllegalArgumentException("Non zero y");
                }
            }
            if (!this._gotRGB && y == 0) {
                this._rgb = rgb;
                this._gotRGB = true;
            }
            if (this._rgb == rgb) {
                return 0;
            }
            return rgb;
        }
    }

    private static class ProxyContext
    extends PaintContextProxy {
        private PaintContext _context;
        private Graphics _g;

        public ProxyContext(PaintContext wrappedContext, Graphics offscreenG) {
            this._context = wrappedContext;
            this._g = offscreenG;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public Graphics getPaintGraphics() {
            return this._g;
        }

        public Font getPaintFont() {
            return this._g.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return this._g.getFontMetrics(font);
        }
    }
}

