/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.myfaces.tobago.model.TreePath;

public class SelectedState
implements Serializable {
    private Set<TreePath> selectedPaths = new HashSet<TreePath>();

    public boolean isSelected(TreePath path) {
        return this.selectedPaths.contains(path);
    }

    public boolean isAncestorOfSelected(TreePath ancestorPath) {
        if (ancestorPath.isRoot()) {
            return !this.selectedPaths.isEmpty();
        }
        Iterator<TreePath> iterator = this.selectedPaths.iterator();
        while (iterator.hasNext()) {
            TreePath selectedPath;
            TreePath p = selectedPath = iterator.next();
            while (!p.isRoot()) {
                if (p.equals(ancestorPath)) {
                    return true;
                }
                p = p.getParent();
            }
        }
        return false;
    }

    public void select(TreePath path) {
        this.selectedPaths.add(path);
    }

    public void unselect(TreePath path) {
        this.selectedPaths.remove(path);
    }

    public void clearAndSelect(TreePath path) {
        this.clear();
        this.select(path);
    }

    public void clear() {
        this.selectedPaths.clear();
    }

    public void select(TreePath path, boolean selected) {
        if (selected) {
            this.select(path);
        } else {
            this.unselect(path);
        }
    }

    public String toString() {
        return this.selectedPaths.toString();
    }
}

