/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyListbox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyListboxRenderer<T extends AbstractUISelectManyListbox>
extends SelectManyRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_MANY_LISTBOX;
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUISelectManyListbox)component).getFieldId(facesContext);
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, component);
        boolean readonly = ((AbstractUISelectManyBase)component).isReadonly();
        boolean disabled = !items.iterator().hasNext() || ((AbstractUISelectManyBase)component).isDisabled() || readonly;
        Markup markup = component.getMarkup();
        Integer size = ((AbstractUISelectManyListbox)component).getSize();
        size = Math.max(size != null ? size.intValue() : items.size(), 2);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        SelectManyListboxRenderer.renderFocus(clientId, ((AbstractUISelectManyBase)component).isFocus(), ((AbstractUISelectManyBase)component).isError(), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectManyBase)component).getTabIndex());
        writer.writeClassAttribute(BootstrapClass.FORM_SELECT, BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)), component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        Object[] values = ((AbstractUISelectManyBase)component).getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)component);
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, values, submittedValues, writer, facesContext);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUISelectManyListbox)component).getFieldId(facesContext);
    }
}

