/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginator;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaginatorRenderer<T extends AbstractUIPaginator>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T paginator) {
        String value;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String sourceId = (String)requestParameterMap.get("javax.faces.source");
        String clientId = paginator.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("clientId           {}", (Object)clientId);
            LOG.debug("javax.faces.source {}", (Object)sourceId);
        }
        if (clientId.equals(sourceId) && (value = (String)requestParameterMap.get(clientId)) != null) {
            AbstractUISheet sheet = ((AbstractUIPaginator)paginator).getPageable();
            if (sheet != null) {
                JsonUtils.SheetActionRecord sheetActionRecord = JsonUtils.decodeSheetAction(value);
                LOG.debug("record='{}'", (Object)sheetActionRecord);
                sheet.queueEvent((FacesEvent)new PageActionEvent((UIComponent)sheet, sheetActionRecord));
            } else {
                LOG.warn("No sheet found for paginator {}", (Object)clientId);
            }
        }
    }

    protected void encodeLink(FacesContext facesContext, boolean disabled, SheetAction action, Integer target, Icons icon, CssItem liClass) throws IOException {
        Locale locale = facesContext.getViewRoot().getLocale();
        String message = ResourceUtils.getString(facesContext, action.getBundleKey());
        String tip = new MessageFormat(message, locale).format(new Integer[]{target});
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.LI);
        writer.writeClassAttribute(liClass, disabled ? BootstrapClass.DISABLED : null, BootstrapClass.PAGE_ITEM);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.PAGE_LINK);
        writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute(DataAttributes.ACTION, JsonUtils.encode(action, target), false);
        if (icon != null) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(icon);
            writer.endElement(HtmlElements.I);
        } else {
            writer.writeText(String.valueOf(target));
        }
        writer.endElement(HtmlElements.BUTTON);
        writer.endElement(HtmlElements.LI);
    }
}

