// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIDatePicker;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.DatePickerTagDeclaration}.
 */
public final class DatePickerTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(DatePickerTag.class);
  private String forComponent;
  private javax.el.ValueExpression  tabIndex;
  private javax.el.ValueExpression  markup;

  @Override
  public String getComponentType() {
    return UIDatePicker.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "DatePicker";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIDatePicker component = (UIDatePicker) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (forComponent != null) {
      component.setFor(forComponent);
    }

    if (tabIndex != null) {
      if (!tabIndex.isLiteralText()) {
        component.setValueExpression("tabIndex", tabIndex);
      } else {
        component.setTabIndex(Integer.parseInt(tabIndex.getExpressionString()));
      }
    }
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
  }

  public String getFor() {
    return forComponent;
  }

  public void setFor(final String forComponent) {
    this.forComponent = forComponent;
  }

  public javax.el.ValueExpression getTabIndex() {
    return tabIndex;
  }

  public void setTabIndex(final javax.el.ValueExpression tabIndex) {
    this.tabIndex = tabIndex;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }



  @Override
  public void release() {
    super.release();
    forComponent = null;
    tabIndex = null;
    markup = null;
  }
}