/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBox;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.internal.component.UISelect2Component;
import org.apache.myfaces.tobago.model.SubmittedItem;
import org.apache.myfaces.tobago.model.UICustomItemContainer;
import org.apache.myfaces.tobago.util.SelectItemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UISelect2ComponentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UISelect2ComponentUtil.class);
    private static final String VALID_CUSTOMITEM_MAP = "org.apache.myfaces.tobago.internal.util.UISelect2ComponentUtil.valid_CustomItem_Map";

    private UISelect2ComponentUtil() {
    }

    public static Object ensureCustomValue(FacesContext facesContext, UISelect2Component component, Object value) {
        if (value != null && !"".equals(value)) {
            AbstractUISuggest suggest = component.getSuggest();
            if (component.isAllowCustom() || suggest != null) {
                UISelect2ComponentUtil.ensureCustomValue(facesContext, component, value, suggest);
            }
        }
        return value;
    }

    public static Object ensureCustomValues(FacesContext facesContext, UISelect2Component component, Object values) {
        block6: {
            if (values == null) break block6;
            AbstractUISuggest suggest = component.getSuggest();
            if (component.isAllowCustom() || suggest != null) {
                if (values instanceof Object[]) {
                    for (Object value : (Object[])values) {
                        UISelect2ComponentUtil.ensureCustomValue(facesContext, component, value, suggest);
                    }
                } else if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        UISelect2ComponentUtil.ensureCustomValue(facesContext, component, value, suggest);
                    }
                }
            }
        }
        return values;
    }

    public static void ensureCustomValue(FacesContext facesContext, UISelect2Component component, Object value, AbstractUISuggest suggest) {
        if (!UISelect2ComponentUtil.isInItemList(facesContext, component, value)) {
            SelectItem item = null;
            if (suggest != null) {
                item = suggest.getSelectItem(facesContext, value, component.getConverter());
            }
            if (item == null && component.isAllowCustom()) {
                item = new org.apache.myfaces.tobago.model.SelectItem(value);
            }
            if (item != null) {
                LOG.trace("ADD item = \"{}\"", item.getValue());
                UISelect2ComponentUtil.getValidCustomItemMap(component).add(item);
            }
        }
    }

    private static boolean isInItemList(FacesContext facesContext, UISelect2Component component, Object value) {
        LOG.trace("check for value = \"{}\"", value);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)component);
        for (SelectItem item : items) {
            LOG.trace("check item value = \"{}\"", item.getValue());
            if (item.getValue() == null || !item.getValue().equals(value)) continue;
            LOG.trace("TRUE");
            return true;
        }
        LOG.trace("false");
        return false;
    }

    public static Set<SelectItem> getValidCustomItemMap(UISelect2Component component) {
        Object o = component.getComponentStateHelper().get((Serializable)((Object)VALID_CUSTOMITEM_MAP));
        HashSet set = (HashSet)o;
        if (set == null) {
            set = new HashSet();
            component.getComponentStateHelper().put((Serializable)((Object)VALID_CUSTOMITEM_MAP), set);
        }
        return set;
    }

    public static void ensureCustomItemsContainer(FacesContext facesContext, UISelect2Component component) {
        Set<SelectItem> validCustomItemMap = UISelect2ComponentUtil.getValidCustomItemMap(component);
        boolean done = false;
        for (UIComponent child : ((UIComponent)component).getChildren()) {
            if (!(child instanceof UICustomItemContainer)) continue;
            ((UICustomItemContainer)child).setValue(validCustomItemMap);
            done = true;
            break;
        }
        if (!done) {
            UICustomItemContainer uiCustomItemContainer = new UICustomItemContainer(validCustomItemMap);
            uiCustomItemContainer.setId(((UIComponent)component).getId() + "_customItemContainer");
            ((UIComponent)component).getChildren().add(uiCustomItemContainer);
        }
        if (component instanceof AbstractUISelectManyBox) {
            HashSet<SelectItem> set = new HashSet<SelectItem>(validCustomItemMap);
            validCustomItemMap.clear();
            for (SelectItem selectItem : set) {
                LOG.trace("cleanup check = \"{}\"", selectItem.getValue());
                if (UISelect2ComponentUtil.isInItemList(facesContext, component, selectItem.getValue())) continue;
                LOG.trace("cleanup readd = \"{}\"", selectItem.getValue());
                validCustomItemMap.add(selectItem);
            }
        }
    }

    public static Iterable<SelectItem> ensureSubmittedValues(FacesContext facesContext, UIInput component, Iterable<SelectItem> items, String[] submittedValues) {
        if (submittedValues == null || !(component instanceof UISelect2Component)) {
            return items;
        }
        Converter converter = component.getConverter();
        ArrayList<SelectItem> itemsToRender = new ArrayList<SelectItem>();
        HashMap<String, SelectItem> optionValues = new HashMap<String, SelectItem>();
        for (SelectItem item : items) {
            itemsToRender.add(item);
            Object itemValue = item.getValue();
            if (converter != null) {
                optionValues.put(converter.getAsString(facesContext, (UIComponent)component, itemValue), item);
                continue;
            }
            optionValues.put(itemValue != null ? itemValue.toString() : null, item);
        }
        for (String submittedValue : submittedValues) {
            if (optionValues.keySet().contains(submittedValue)) continue;
            itemsToRender.add(new SubmittedItem(submittedValue));
        }
        return itemsToRender;
    }
}

