/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeI18n {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeI18n.class);
    private static final Map<Locale, DateTimeI18n> CACHE = new HashMap<Locale, DateTimeI18n>();
    private final String[] monthNames = new String[12];
    private final String[] monthNamesShort = new String[12];
    private final String[] dayNames = new String[7];
    private final String[] dayNamesShort = new String[7];
    private final String[] dayNamesMin = new String[7];
    private final int firstDay;

    private DateTimeI18n(Locale locale) {
        LOG.debug("Creating DateTimeI18n for locale: " + locale);
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(2000, 0, 1);
        SimpleDateFormat dateFormatMMMMM = new SimpleDateFormat("MMMMM", locale);
        SimpleDateFormat dateFormatMMM = new SimpleDateFormat("MMM", locale);
        for (int i = 0; i < this.monthNames.length; ++i) {
            this.monthNames[i] = dateFormatMMMMM.format(calendar.getTime());
            this.monthNamesShort[i] = dateFormatMMM.format(calendar.getTime());
            calendar.add(2, 1);
        }
        SimpleDateFormat dateFormatEEEEE = new SimpleDateFormat("EEEEE", locale);
        SimpleDateFormat dateFormatEEE = new SimpleDateFormat("EEE", locale);
        SimpleDateFormat dateFormatE = new SimpleDateFormat("E", locale);
        calendar.set(2000, 0, 2);
        for (int i = 0; i < this.dayNames.length; ++i) {
            this.dayNames[i] = dateFormatEEEEE.format(calendar.getTime());
            this.dayNamesShort[i] = dateFormatEEE.format(calendar.getTime());
            this.dayNamesMin[i] = dateFormatE.format(calendar.getTime());
            calendar.add(6, 1);
        }
        this.firstDay = calendar.getFirstDayOfWeek() - 1;
    }

    public static synchronized DateTimeI18n valueOf(Locale locale) {
        DateTimeI18n dateTimeI18n = CACHE.get(locale);
        if (dateTimeI18n == null) {
            dateTimeI18n = new DateTimeI18n(locale);
            CACHE.put(locale, dateTimeI18n);
        }
        return dateTimeI18n;
    }

    public String[] getMonthNames() {
        return this.monthNames;
    }

    public String[] getMonthNamesShort() {
        return this.monthNamesShort;
    }

    public String[] getDayNames() {
        return this.dayNames;
    }

    public String[] getDayNamesShort() {
        return this.dayNamesShort;
    }

    public String[] getDayNamesMin() {
        return this.dayNamesMin;
    }

    public int getFirstDay() {
        return this.firstDay;
    }
}

