/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISelectManyCheckbox;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyCheckboxRenderer
extends SelectManyRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        super.prepareRender(facesContext, (UIComponent)select);
        if (select.isInline()) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)select, (Markup)Markup.INLINE);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String id = select.getClientId(facesContext);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        boolean required = select.isRequired();
        style.setDisplay(null);
        writer.startElement("ol", (UIComponent)select);
        writer.writeIdAttribute(id);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        boolean first = true;
        Object[] values = select.getSelectedValues();
        Object[] submittedValues = this.getSubmittedValues((UIInput)select);
        int i = 0;
        for (SelectItem item : SelectItemUtils.getItemIterator(facesContext, (UIComponent)select)) {
            Integer tabIndex;
            String itemId = id + "::" + i++;
            writer.startElement("li", (UIComponent)select);
            writer.startElement("input", (UIComponent)select);
            writer.writeAttribute("type", "checkbox", false);
            String formattedValue = RenderUtils.getFormattedValue(facesContext, (UIComponent)select, item.getValue());
            boolean checked = submittedValues == null ? RenderUtils.contains(values, item.getValue()) : RenderUtils.contains(submittedValues, formattedValue);
            writer.writeAttribute("checked", checked);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            writer.writeAttribute("value", formattedValue, true);
            writer.writeAttribute("disabled", item.isDisabled() || disabled);
            writer.writeAttribute("readonly", readonly);
            writer.writeAttribute("required", required);
            if (first) {
                HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
                first = false;
            }
            if ((tabIndex = select.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            HtmlRendererUtils.renderCommandFacet((UIComponent)select, itemId, facesContext, writer);
            writer.endElement("input");
            String label = item.getLabel();
            if (label != null) {
                writer.startElement("label", (UIComponent)select);
                writer.writeAttribute("for", itemId, false);
                writer.writeText(label);
                writer.endElement("label");
            }
            writer.endElement("li");
        }
        writer.endElement("ol");
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        Measure heightOfOne = super.getHeight(facesContext, component);
        if (select.isInline()) {
            return heightOfOne;
        }
        int count = 0;
        for (SelectItem ignored : SelectItemUtils.getItemIterator(facesContext, (UIComponent)((UISelectMany)component))) {
            ++count;
        }
        return heightOfOne.multiply(count);
    }
}

