/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.component.Form;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.TobagoCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIForm
extends UIForm
implements Form {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIForm.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Form";
    public static final String SUBMITTED_MARKER = "org.apache.myfaces.tobago.Form.InSubmitted";

    public void processDecodes(FacesContext facesContext) {
        this.decode(facesContext);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
    }

    public void setSubmitted(boolean b) {
        super.setSubmitted(b);
        for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
            subForm.setSubmitted(b);
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processValidators for form: {}", (Object)this.getClientId(facesContext));
        }
        if (!this.isSubmitted()) {
            for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
                subForm.processValidators(facesContext);
            }
        } else {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processValidators(facesContext);
            }
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processUpdates for form: {}", (Object)this.getClientId(facesContext));
        }
        if (!this.isSubmitted()) {
            for (AbstractUIForm subForm : ComponentUtils.findSubForms((UIComponent)this)) {
                subForm.processUpdates(facesContext);
            }
        } else {
            Iterator kids = this.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                kid.processUpdates(facesContext);
            }
        }
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (callback instanceof TobagoCallback && PhaseId.APPLY_REQUEST_VALUES.equals(((TobagoCallback)callback).getPhaseId())) {
            this.decode(context);
        }
        context.getExternalContext().getRequestMap().put(SUBMITTED_MARKER, this.isSubmitted());
        return super.invokeOnComponent(context, clientId, callback);
    }
}

