/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.Set;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.swap.BeanInterceptor;

public final class BeanFilter {
    private final Class<?> beanClass;
    private final Set<String> properties;
    private final Set<String> excludeProperties;
    private final Set<String> readOnlyProperties;
    private final Set<String> writeOnlyProperties;
    private final PropertyNamer propertyNamer;
    private final Class<?> implClass;
    private final Class<?> interfaceClass;
    private final Class<?> stopClass;
    private final boolean sortProperties;
    private final boolean fluentSetters;
    private final String typeName;
    private final String example;
    private final Class<?>[] beanDictionary;
    private final BeanInterceptor interceptor;

    public static <T> Builder create(Class<T> beanClass) {
        return new Builder(beanClass);
    }

    BeanFilter(Builder builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.properties = CollectionUtils.copyOf(builder.properties);
        this.excludeProperties = CollectionUtils.copyOf(builder.excludeProperties);
        this.readOnlyProperties = CollectionUtils.copyOf(builder.readOnlyProperties);
        this.writeOnlyProperties = CollectionUtils.copyOf(builder.writeOnlyProperties);
        this.example = builder.example;
        this.implClass = builder.implClass;
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.fluentSetters = builder.fluentSetters;
        this.propertyNamer = builder.propertyNamer.orElse(null);
        this.beanDictionary = builder.dictionary == null ? null : builder.dictionary.toArray(new Class[builder.dictionary.size()]);
        this.interceptor = builder.interceptor.orElse(BeanInterceptor.DEFAULT);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class<?>[] getBeanDictionary() {
        return this.beanDictionary;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public Set<String> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public Set<String> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public boolean isFluentSetters() {
        return this.fluentSetters;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<?> getStopClass() {
        return this.stopClass;
    }

    public String getExample() {
        return this.example;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return this.interceptor.readProperty(bean, name, value);
    }

    public Object writeProperty(Object bean, String name, Object value) {
        return this.interceptor.writeProperty(bean, name, value);
    }

    public static class Builder {
        Class<?> beanClass;
        String typeName;
        String example;
        Set<String> properties = CollectionUtils.set(new String[0]);
        Set<String> excludeProperties = CollectionUtils.set(new String[0]);
        Set<String> readOnlyProperties = CollectionUtils.set(new String[0]);
        Set<String> writeOnlyProperties = CollectionUtils.set(new String[0]);
        Class<?> implClass;
        Class<?> interfaceClass;
        Class<?> stopClass;
        boolean sortProperties;
        boolean fluentSetters;
        BeanCreator<PropertyNamer> propertyNamer = BeanCreator.of(PropertyNamer.class);
        List<Class<?>> dictionary;
        BeanCreator<BeanInterceptor> interceptor = BeanCreator.of(BeanInterceptor.class);

        protected Builder(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public Builder applyAnnotations(List<Bean> annotations) {
            annotations.forEach(x -> {
                if (StringUtils.isNotEmpty(x.properties(), x.p())) {
                    this.properties(x.properties(), x.p());
                }
                if (x.sort()) {
                    this.sortProperties(true);
                }
                if (x.findFluentSetters()) {
                    this.findFluentSetters();
                }
                if (StringUtils.isNotEmpty(x.excludeProperties(), x.xp())) {
                    this.excludeProperties(x.excludeProperties(), x.xp());
                }
                if (StringUtils.isNotEmpty(x.readOnlyProperties(), x.ro())) {
                    this.readOnlyProperties(x.readOnlyProperties(), x.ro());
                }
                if (StringUtils.isNotEmpty(x.writeOnlyProperties(), x.wo())) {
                    this.writeOnlyProperties(x.writeOnlyProperties(), x.wo());
                }
                if (StringUtils.isNotEmpty(x.typeName())) {
                    this.typeName(x.typeName());
                }
                if (ClassUtils.isNotVoid(x.propertyNamer())) {
                    this.propertyNamer(x.propertyNamer());
                }
                if (ClassUtils.isNotVoid(x.interfaceClass())) {
                    this.interfaceClass(x.interfaceClass());
                }
                if (ClassUtils.isNotVoid(x.stopClass())) {
                    this.stopClass(x.stopClass());
                }
                if (ClassUtils.isNotVoid(x.interceptor())) {
                    this.interceptor(x.interceptor());
                }
                if (ClassUtils.isNotVoid(x.implClass())) {
                    this.implClass(x.implClass());
                }
                if (ArrayUtils.isNotEmptyArray(x.dictionary())) {
                    this.dictionary(x.dictionary());
                }
                if (StringUtils.isNotEmpty(x.example())) {
                    this.example(x.example());
                }
            });
            return this;
        }

        public Builder typeName(String value) {
            this.typeName = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        public Builder interfaceClass(Class<?> value) {
            this.interfaceClass = value;
            return this;
        }

        public Builder stopClass(Class<?> value) {
            this.stopClass = value;
            return this;
        }

        public Builder sortProperties(boolean value) {
            this.sortProperties = value;
            return this;
        }

        public Builder sortProperties() {
            this.sortProperties = true;
            return this;
        }

        public Builder findFluentSetters() {
            this.fluentSetters = true;
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer.type(value);
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.properties.add((String)x));
            }
            return this;
        }

        public Builder excludeProperties(String ... value) {
            this.excludeProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.excludeProperties.add((String)x));
            }
            return this;
        }

        public Builder readOnlyProperties(String ... value) {
            this.readOnlyProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.readOnlyProperties.add((String)x));
            }
            return this;
        }

        public Builder writeOnlyProperties(String ... value) {
            this.writeOnlyProperties = CollectionUtils.set(new String[0]);
            for (String v : value) {
                StringUtils.split(v, x -> this.writeOnlyProperties.add((String)x));
            }
            return this;
        }

        public Builder dictionary(Class<?> ... values) {
            if (this.dictionary == null) {
                this.dictionary = CollectionUtils.list(values);
            } else {
                for (Class<?> cc : values) {
                    this.dictionary.add(cc);
                }
            }
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder interceptor(Class<?> value) {
            this.interceptor.type(value);
            return this;
        }

        public BeanFilter build() {
            return new BeanFilter(this);
        }
    }
}

