/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Predicate;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodProperties;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestMethodAnnotation;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;

public class RestMethodContextBuilder
extends BeanContextBuilder {
    RestContext context;
    Method method;
    boolean dotAll;
    RestMethodProperties properties;

    RestMethodContextBuilder(Object servlet, Method method, RestContext context) throws RestServletException {
        this.context = context;
        this.method = method;
        String sig = method.getDeclaringClass().getName() + '.' + method.getName();
        MethodInfo mi = MethodInfo.of(servlet.getClass(), (Method)method, (Method)method);
        try {
            RestMethod m = (RestMethod)mi.getLastAnnotation(RestMethod.class);
            if (m == null) {
                for (Method mi2 : mi.getMatching()) {
                    Class<?> ci2 = mi2.getDeclaringClass();
                    if (!ci2.isInterface() || ci2.getAnnotation(Rest.class) == null) continue;
                    m = new RestMethodAnnotation();
                }
            }
            if (m == null) {
                throw new RestServletException("@RestMethod annotation not found on method ''{0}''", sig);
            }
            VarResolver vr = context.getVarResolver();
            VarResolverSession vrs = vr.createSession();
            this.applyAnnotations(mi.getAnnotationList((Predicate)ConfigAnnotationFilter.INSTANCE), vrs);
            this.properties = new RestMethodProperties(context.getProperties());
            if (m.properties().length > 0 || m.flags().length > 0) {
                this.properties = new RestMethodProperties(this.properties);
                for (Property property : m.properties()) {
                    this.properties.put(property.name(), property.value());
                }
                for (String string : m.flags()) {
                    this.properties.put(string, true);
                }
            }
        }
        catch (RestServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestServletException(e, "Exception occurred while initializing method ''{0}''", sig);
        }
    }

    public RestMethodContextBuilder dotAll() {
        this.dotAll = true;
        return this;
    }

    public RestMethodContextBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    public RestMethodContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    public RestMethodContextBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    public RestMethodContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    public RestMethodContextBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    public RestMethodContextBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    public RestMethodContextBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    public RestMethodContextBuilder debug() {
        super.debug();
        return this;
    }

    public RestMethodContextBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public RestMethodContextBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public RestMethodContextBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    public RestMethodContextBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    public RestMethodContextBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    public RestMethodContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    public RestMethodContextBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    public RestMethodContextBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    public RestMethodContextBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public RestMethodContextBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    public RestMethodContextBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public RestMethodContextBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public RestMethodContextBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public RestMethodContextBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor(on, value);
        return this;
    }

    public RestMethodContextBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    public RestMethodContextBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    public RestMethodContextBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    public RestMethodContextBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    public RestMethodContextBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    public RestMethodContextBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    public RestMethodContextBuilder bpi(Map<String, Object> values) {
        super.bpi(values);
        return this;
    }

    public RestMethodContextBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi(beanClass, properties);
        return this;
    }

    public RestMethodContextBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    public RestMethodContextBuilder bpro(Map<String, Object> values) {
        super.bpro(values);
        return this;
    }

    public RestMethodContextBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro(beanClass, properties);
        return this;
    }

    public RestMethodContextBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    public RestMethodContextBuilder bpwo(Map<String, Object> values) {
        super.bpwo(values);
        return this;
    }

    public RestMethodContextBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    public RestMethodContextBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    public RestMethodContextBuilder bpx(Map<String, Object> values) {
        super.bpx(values);
        return this;
    }

    public RestMethodContextBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    public RestMethodContextBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    public RestMethodContextBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    public RestMethodContextBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn(on, (Class[])values);
        return this;
    }

    public RestMethodContextBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    public RestMethodContextBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    public RestMethodContextBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    public RestMethodContextBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    public <T> RestMethodContextBuilder example(Class<T> pojoClass, T o) {
        super.example(pojoClass, o);
        return this;
    }

    public <T> RestMethodContextBuilder exampleJson(Class<T> pojoClass, String json) {
        super.exampleJson(pojoClass, json);
        return this;
    }

    public RestMethodContextBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    public RestMethodContextBuilder fluentSetters(Class<?> on) {
        super.fluentSetters(on);
        return this;
    }

    public RestMethodContextBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    public RestMethodContextBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    public RestMethodContextBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    public RestMethodContextBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public RestMethodContextBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public RestMethodContextBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass(on, value);
        return this;
    }

    public RestMethodContextBuilder interfaces(Class<?> ... value) {
        super.interfaces((Class[])value);
        return this;
    }

    public RestMethodContextBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    public RestMethodContextBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RestMethodContextBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer(value);
        return this;
    }

    public RestMethodContextBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer(on, value);
        return this;
    }

    public RestMethodContextBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    public RestMethodContextBuilder sortProperties(Class<?> ... on) {
        super.sortProperties((Class[])on);
        return this;
    }

    public RestMethodContextBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass(on, value);
        return this;
    }

    public RestMethodContextBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    public RestMethodContextBuilder typeName(Class<?> on, String value) {
        super.typeName(on, value);
        return this;
    }

    public RestMethodContextBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    public RestMethodContextBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName(on, value);
        return this;
    }

    public RestMethodContextBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    public RestMethodContextBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }
}

