/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.mstat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExceptionHasher {
    private final String stopClass;

    public ExceptionHasher(Class<?> stopClass) {
        this.stopClass = stopClass == null ? null : stopClass.getName();
    }

    public int hash(Throwable t) {
        int i = 0;
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                if (e.getClassName().equals(this.stopClass)) break;
                if (e.getClassName().indexOf(36) != -1) continue;
                i ^= e.hashCode();
            }
            t = t.getCause();
        }
        return i;
    }

    public List<StackTraceElement> getStackTrace(Throwable t) {
        ArrayList<StackTraceElement> l = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : t.getStackTrace()) {
            if (e.getClassName().equals(this.stopClass)) break;
            l.add(e);
        }
        return Collections.unmodifiableList(l);
    }
}

