/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.ui.SwaggerUI;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.annotation.JsonSchemaConfig;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestContextStats;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Logging;
import org.apache.juneau.rest.annotation.LoggingRule;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.serializer.annotation.SerializerConfig;
import org.apache.juneau.soap.SoapXmlSerializer;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlDocSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xmlschema.XmlSchemaDocSerializer;

@Rest(serializers={HtmlDocSerializer.class, HtmlStrippedDocSerializer.class, HtmlSchemaDocSerializer.class, JsonSerializer.class, SimpleJsonSerializer.class, JsonSchemaSerializer.class, XmlDocSerializer.class, XmlSchemaDocSerializer.class, UonSerializer.class, UrlEncodingSerializer.class, OpenApiSerializer.class, MsgPackSerializer.class, SoapXmlSerializer.class, PlainTextSerializer.class}, parsers={JsonParser.class, JsonParser.Simple.class, XmlParser.class, HtmlParser.class, UonParser.class, UrlEncodingParser.class, OpenApiParser.class, MsgPackParser.class, PlainTextParser.class}, config="$S{juneau.configFile,SYSTEM_DEFAULT}", staticFiles={"$C{REST/staticFiles,htdocs:/htdocs,htdocs:htdocs}"}, logging=@Logging(level="INFO", useStackTraceHashing="true", rules={@LoggingRule(codes="500-", level="WARNING")}))
@SerializerConfig(uriResolution="ROOT_RELATIVE")
@HtmlDocConfig(header={"<h1>$R{resourceTitle}</h1>", "<h2>$R{methodSummary,resourceDescription}</h2>", "$C{REST/header}"}, navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS", "stats: servlet:/stats"}, stylesheet={"$C{REST/theme,servlet:/htdocs/themes/devops.css}"}, head={"$C{REST/head}"}, footer={"$C{REST/footer}"}, nowrap="true")
@JsonSchemaConfig(addDescriptionsTo="bean,collection,array,map,enum", addExamplesTo="bean,collection,array,map", ignoreTypes="Swagger,org.apache.juneau.dto.html5.*", useBeanDefs="true")
@BeanConfig(ignoreUnknownBeanProperties="true", pojoSwaps={SwaggerUI.class})
public interface BasicRestConfig {
    @RestMethod(name="OPTIONS", path="/*", summary="Swagger documentation", description={"Swagger documentation for this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/?method=OPTIONS&Accept=text/json&plainText=true"}, aside={"NONE"})
    public Swagger getOptions(RestRequest var1);

    @RestMethod(name="*", path="/error", summary="Error occurred", description={"An error occurred during handling of the request."})
    public void error();

    @RestMethod(name="GET", path="/stats", summary="Timing statistics", description={"Timing statistics for method invocations on this resource."})
    @HtmlDocConfig(rank=10, navlinks={"back: servlet:/", "json: servlet:/stats?Accept=text/json&plainText=true"}, aside={"NONE"})
    public RestContextStats getStats(RestRequest var1);
}

