/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import org.apache.juneau.UriResolver;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlUtils;

public class XmlWriter
extends SerializerWriter {
    private String defaultNsPrefix;
    private boolean enableNs;

    public XmlWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver, boolean enableNs, Namespace defaultNamespace) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
        this.enableNs = enableNs;
        this.defaultNsPrefix = defaultNamespace == null ? null : defaultNamespace.name;
    }

    public XmlWriter oTag(String ns, String name, boolean needsEncoding) throws IOException {
        this.append('<');
        if (this.enableNs && ns != null && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.append(ns).append(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.append(name);
        }
        return this;
    }

    public XmlWriter oTag(String ns, String name) throws IOException {
        return this.oTag(ns, name, false);
    }

    public XmlWriter oTag(String name) throws IOException {
        return this.oTag(null, name, false);
    }

    public XmlWriter oTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        return this.i(indent).oTag(ns, name, needsEncoding);
    }

    public XmlWriter oTag(int indent, String ns, String name) throws IOException {
        return this.i(indent).oTag(ns, name, false);
    }

    public XmlWriter oTag(int indent, String name) throws IOException {
        return this.i(indent).oTag(null, name, false);
    }

    public XmlWriter cTag() throws IOException {
        this.append('>');
        return this;
    }

    public XmlWriter ceTag() throws IOException {
        this.append('/').append('>');
        return this;
    }

    public XmlWriter tag(String ns, String name, boolean needsEncoding) throws IOException {
        this.append('<');
        if (this.enableNs && ns != null && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.append(ns).append(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.append(name);
        }
        return this.append('/').append('>');
    }

    public XmlWriter tag(String ns, String name) throws IOException {
        return this.tag(ns, name, false);
    }

    public XmlWriter tag(String name) throws IOException {
        return this.tag(null, name, false);
    }

    public XmlWriter tag(int indent, String name) throws IOException {
        return this.i(indent).tag(name);
    }

    public XmlWriter tag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        return this.i(indent).tag(ns, name, needsEncoding);
    }

    public XmlWriter tag(int indent, String ns, String name) throws IOException {
        return this.i(indent).tag(ns, name);
    }

    public XmlWriter sTag(String ns, String name, boolean needsEncoding) throws IOException {
        return this.oTag(ns, name, needsEncoding).append('>');
    }

    public XmlWriter sTag(String ns, String name) throws IOException {
        return this.sTag(ns, name, false);
    }

    public XmlWriter sTag(String name) throws IOException {
        return this.sTag(null, name);
    }

    public XmlWriter sTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        return this.i(indent).sTag(ns, name, needsEncoding);
    }

    public XmlWriter sTag(int indent, String ns, String name) throws IOException {
        return this.i(indent).sTag(ns, name, false);
    }

    public XmlWriter sTag(int indent, String name) throws IOException {
        return this.i(indent).sTag(null, name, false);
    }

    public XmlWriter eTag(String ns, String name, boolean needsEncoding) throws IOException {
        this.append('<').append('/');
        if (this.enableNs && ns != null && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.append(ns).append(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.append(name);
        }
        return this.append('>');
    }

    public XmlWriter eTag(String ns, String name) throws IOException {
        return this.eTag(ns, name, false);
    }

    public XmlWriter eTag(String name) throws IOException {
        return this.eTag(null, name);
    }

    public XmlWriter eTag(int indent, String ns, String name, boolean needsEncoding) throws IOException {
        return this.i(indent).eTag(ns, name, needsEncoding);
    }

    public XmlWriter eTag(int indent, String ns, String name) throws IOException {
        return this.i(indent).eTag(ns, name, false);
    }

    public XmlWriter eTag(int indent, String name) throws IOException {
        return this.i(indent).eTag(name);
    }

    public XmlWriter attr(String ns, String name, Object value, boolean valNeedsEncoding) throws IOException {
        return this.oAttr(ns, name).q().attrValue(value, valNeedsEncoding).q();
    }

    public XmlWriter attr(String name, Object value, boolean valNeedsEncoding) throws IOException {
        return this.attr(null, name, value, valNeedsEncoding);
    }

    public XmlWriter attr(String ns, String name, Object value) throws IOException {
        return this.oAttr(ns, name).q().attrValue(value, false).q();
    }

    public XmlWriter attr(Namespace ns, String name, Object value) throws IOException {
        return this.oAttr(ns == null ? null : ns.name, name).q().attrValue(value, false).q();
    }

    public XmlWriter attr(String name, Object value) throws IOException {
        return this.attr((String)null, name, value);
    }

    public XmlWriter oAttr(String ns, String name) throws IOException {
        this.append(' ');
        if (this.enableNs && ns != null && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.append(ns).append(':');
        }
        this.append(name).append('=');
        return this;
    }

    public XmlWriter oAttr(Namespace ns, String name) throws IOException {
        return this.oAttr(ns == null ? null : ns.name, name);
    }

    public XmlWriter attrUri(Namespace ns, String name, Object value) throws IOException {
        return this.attr(ns, name, (Object)this.uriResolver.resolve(value));
    }

    public XmlWriter attrUri(String ns, String name, Object value) throws IOException {
        return this.attr(ns, name, this.uriResolver.resolve(value), true);
    }

    public XmlWriter attrUri(String name, Object value) throws IOException {
        return this.attrUri((String)null, name, value);
    }

    public XmlWriter text(Object o) throws IOException {
        this.text(o, false);
        return this;
    }

    public XmlWriter text(Object o, boolean preserveWhitespace) throws IOException {
        XmlUtils.encodeText(this, o, this.trimStrings, preserveWhitespace);
        return this;
    }

    public XmlWriter textUri(Object o) throws IOException {
        this.text(this.uriResolver.resolve(o), false);
        return this;
    }

    private XmlWriter attrValue(Object o, boolean needsEncoding) throws IOException {
        if (needsEncoding) {
            XmlUtils.encodeAttrValue(this.out, o, this.trimStrings);
        } else if (o instanceof URI || o instanceof URL) {
            this.append(this.uriResolver.resolve(o));
        } else {
            this.append(o);
        }
        return this;
    }

    @Override
    public XmlWriter cr(int depth) throws IOException {
        super.cr(depth);
        return this;
    }

    @Override
    public XmlWriter cre(int depth) throws IOException {
        super.cre(depth);
        return this;
    }

    @Override
    public XmlWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public XmlWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public XmlWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public XmlWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public XmlWriter s() throws IOException {
        super.s();
        return this;
    }

    @Override
    public XmlWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public XmlWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public XmlWriter ie(int indent) throws IOException {
        super.ie(indent);
        return this;
    }

    @Override
    public XmlWriter nl(int indent) throws IOException {
        super.nl(indent);
        return this;
    }

    @Override
    public XmlWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public XmlWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public XmlWriter append(char c) throws IOException {
        this.out.write(c);
        return this;
    }

    public String toString() {
        return this.out.toString();
    }
}

