/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Date;
import org.apache.juneau.http.EntityValidator;
import org.apache.juneau.http.HeaderString;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.internal.StringUtils;

@Header(value="If-Range")
public final class IfRange
extends HeaderString {
    public static IfRange forString(String value) {
        if (value == null) {
            return null;
        }
        return new IfRange(value);
    }

    private IfRange(String value) {
        super(value);
    }

    public Date asDate() {
        char c0 = StringUtils.charAt(this.value, 0);
        char c1 = StringUtils.charAt(this.value, 1);
        if (c0 == '*' || c0 == '\"' || c0 == 'W' && c1 == '/') {
            return null;
        }
        return DateUtils.parseDate(this.toString());
    }

    public EntityValidator asValidator() {
        char c0 = StringUtils.charAt(this.value, 0);
        char c1 = StringUtils.charAt(this.value, 1);
        if (c0 == '*' || c0 == '\"' || c0 == 'W' && c1 == '/') {
            return new EntityValidator(this.value);
        }
        return null;
    }
}

