/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.concurrent.ConcurrentHashMap;

public class Cache<K, V> {
    private final boolean nocache;
    private final int maxSize;
    private final ConcurrentHashMap<K, V> cache;

    public Cache(boolean disabled, int maxSize) {
        this.nocache = disabled;
        this.maxSize = maxSize;
        this.cache = !this.nocache ? new ConcurrentHashMap() : null;
    }

    public V get(K key) {
        if (this.nocache) {
            return null;
        }
        return this.cache.get(key);
    }

    public V put(K key, V value) {
        V v;
        if (this.nocache) {
            return value;
        }
        if (this.cache.size() > this.maxSize) {
            this.cache.clear();
        }
        if ((v = this.cache.get(key)) != null) {
            return v;
        }
        this.cache.putIfAbsent(key, value);
        return value;
    }
}

