/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jetty.io.ByteBufferAggregator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Invocable;

public class IOResources {
    public static RetainableByteBuffer toRetainableByteBuffer(Resource resource, ByteBufferPool bufferPool, boolean direct) throws IllegalArgumentException {
        RetainableByteBuffer retainableByteBuffer;
        block27: {
            if (resource.isDirectory() || !resource.exists()) {
                throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
            }
            if (resource instanceof Content.Source.Factory) {
                Content.Source.Factory factory = (Content.Source.Factory)((Object)resource);
                try {
                    ByteBuffer buffer = Content.Source.asByteBuffer(factory.newContentSource(new ByteBufferPool.Sized(bufferPool, direct, 0), 0L, -1L));
                    return RetainableByteBuffer.wrap(buffer);
                }
                catch (IOException e2) {
                    throw new RuntimeIOException(e2);
                }
            }
            if (resource instanceof MemoryResource) {
                MemoryResource memoryResource = (MemoryResource)resource;
                return RetainableByteBuffer.wrap(ByteBuffer.wrap(memoryResource.getBytes()));
            }
            long longLength = resource.length();
            if (longLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Resource length exceeds 2 GiB: " + String.valueOf(resource));
            }
            int length = (int)longLength;
            bufferPool = bufferPool == null ? ByteBufferPool.NON_POOLING : bufferPool;
            Path path = resource.getPath();
            if (path != null) {
                RetainableByteBuffer retainableByteBuffer2;
                block26: {
                    RetainableByteBuffer retainableByteBuffer3 = bufferPool.acquire(length, direct);
                    SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);
                    try {
                        int read;
                        ByteBuffer byteBuffer = retainableByteBuffer3.getByteBuffer();
                        int pos = BufferUtil.flipToFill(byteBuffer);
                        for (long totalRead = 0L; totalRead < (long)length && (read = seekableByteChannel.read(byteBuffer)) != -1; totalRead += (long)read) {
                        }
                        BufferUtil.flipToFlush(byteBuffer, pos);
                        retainableByteBuffer2 = retainableByteBuffer3;
                        if (seekableByteChannel == null) break block26;
                    }
                    catch (Throwable totalRead) {
                        try {
                            if (seekableByteChannel != null) {
                                try {
                                    seekableByteChannel.close();
                                }
                                catch (Throwable throwable) {
                                    totalRead.addSuppressed(throwable);
                                }
                            }
                            throw totalRead;
                        }
                        catch (IOException e3) {
                            retainableByteBuffer3.release();
                            throw new RuntimeIOException(e3);
                        }
                    }
                    seekableByteChannel.close();
                }
                return retainableByteBuffer2;
            }
            InputStream inputStream = resource.newInputStream();
            try {
                int read;
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
                }
                ByteBufferAggregator aggregator = new ByteBufferAggregator(bufferPool, direct, length > -1 ? length : 4096, length > -1 ? length : Integer.MAX_VALUE);
                byte[] byteArray = new byte[4096];
                while ((read = inputStream.read(byteArray)) != -1) {
                    aggregator.aggregate(ByteBuffer.wrap(byteArray, 0, read));
                }
                retainableByteBuffer = aggregator.takeRetainableByteBuffer();
                if (inputStream == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e4) {
                    throw new RuntimeIOException(e4);
                }
            }
            inputStream.close();
        }
        return retainableByteBuffer;
    }

    public static Content.Source asContentSource(Resource resource, ByteBufferPool bufferPool, int bufferSize, boolean direct) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        if (resource instanceof Content.Source.Factory) {
            Content.Source.Factory factory = (Content.Source.Factory)((Object)resource);
            return factory.newContentSource(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), 0L, -1L);
        }
        Path path = resource.getPath();
        if (path != null) {
            return Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), path);
        }
        if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            return new ByteBufferContentSource(ByteBuffer.wrap(memoryResource.getBytes()));
        }
        try {
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            return Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), inputStream);
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static Content.Source asContentSource(Resource resource, ByteBufferPool bufferPool, int bufferSize, boolean direct, long first, long length) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        if (resource instanceof Content.Source.Factory) {
            Content.Source.Factory factory = (Content.Source.Factory)((Object)resource);
            return factory.newContentSource(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), first, length);
        }
        Path path = resource.getPath();
        if (path != null) {
            return Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), path, first, length);
        }
        if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            return Content.Source.from(BufferUtil.slice(ByteBuffer.wrap(memoryResource.getBytes()), Math.toIntExact(first), Math.toIntExact(length)));
        }
        try {
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            return Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), inputStream, first, length);
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static InputStream asInputStream(Resource resource) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        try {
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            return inputStream;
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static void copy(Resource resource, Content.Sink sink, ByteBufferPool bufferPool, int bufferSize, boolean direct, Callback callback) {
        try {
            if (resource.isDirectory() || !resource.exists()) {
                throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
            }
            if (resource instanceof Content.Source.Factory) {
                Content.Source.Factory factory = (Content.Source.Factory)((Object)resource);
                Content.Source source = factory.newContentSource(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), 0L, -1L);
                Content.copy(source, sink, callback);
                return;
            }
            Path path = resource.getPath();
            if (path != null) {
                new PathToSinkCopier(path, sink, bufferPool, bufferSize, direct, callback).iterate();
                return;
            }
            if (resource instanceof MemoryResource) {
                MemoryResource memoryResource = (MemoryResource)resource;
                sink.write(true, ByteBuffer.wrap(memoryResource.getBytes()), callback);
                return;
            }
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            Content.Source source = Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), inputStream, 0L, -1L);
            Content.copy(source, sink, callback);
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    public static void copy(Resource resource, Content.Sink sink, ByteBufferPool bufferPool, int bufferSize, boolean direct, long first, long length, Callback callback) {
        try {
            if (resource.isDirectory() || !resource.exists()) {
                throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
            }
            if (resource instanceof Content.Source.Factory) {
                Content.Source.Factory factory = (Content.Source.Factory)((Object)resource);
                Content.Source source = factory.newContentSource(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), first, length);
                Content.copy(source, sink, callback);
                return;
            }
            Path path = resource.getPath();
            if (path != null) {
                new PathToSinkCopier(path, sink, bufferPool, bufferSize, direct, first, length, callback).iterate();
                return;
            }
            if (resource instanceof MemoryResource) {
                MemoryResource memoryResource = (MemoryResource)resource;
                sink.write(true, BufferUtil.slice(ByteBuffer.wrap(memoryResource.getBytes()), Math.toIntExact(first), Math.toIntExact(length)), callback);
                return;
            }
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            Content.Source source = Content.Source.from(new ByteBufferPool.Sized(bufferPool, direct, bufferSize), inputStream, first, length);
            Content.copy(source, sink, callback);
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    private static class PathToSinkCopier
    extends IteratingNestedCallback {
        private final SeekableByteChannel channel;
        private final Content.Sink sink;
        private final ByteBufferPool pool;
        private final int bufferSize;
        private final boolean direct;
        private long remainingLength;
        private RetainableByteBuffer retainableByteBuffer;
        private boolean terminated;

        public PathToSinkCopier(Path path, Content.Sink sink, ByteBufferPool pool, int bufferSize, boolean direct, Callback callback) throws IOException {
            this(path, sink, pool, bufferSize, direct, -1L, -1L, callback);
        }

        public PathToSinkCopier(Path path, Content.Sink sink, ByteBufferPool pool, int bufferSize, boolean direct, long first, long length, Callback callback) throws IOException {
            super(callback);
            this.channel = Files.newByteChannel(path, new OpenOption[0]);
            if (first > -1L) {
                this.channel.position(first);
            }
            this.sink = sink;
            this.pool = pool == null ? ByteBufferPool.NON_POOLING : pool;
            this.bufferSize = bufferSize <= 0 ? 4096 : bufferSize;
            this.direct = direct;
            this.remainingLength = length;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        protected IteratingCallback.Action process() throws Throwable {
            if (this.terminated) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this.retainableByteBuffer == null) {
                this.retainableByteBuffer = this.pool.acquire(this.bufferSize, this.direct);
            }
            ByteBuffer byteBuffer = this.retainableByteBuffer.getByteBuffer();
            BufferUtil.clearToFill(byteBuffer);
            if (this.remainingLength >= 0L && this.remainingLength < Integer.MAX_VALUE) {
                byteBuffer.limit((int)Math.min((long)byteBuffer.capacity(), this.remainingLength));
            }
            boolean eof = false;
            while (byteBuffer.hasRemaining() && !eof) {
                int read = this.channel.read(byteBuffer);
                if (read == -1) {
                    eof = true;
                    continue;
                }
                if (this.remainingLength < 0L) continue;
                this.remainingLength -= (long)read;
            }
            BufferUtil.flipToFlush(byteBuffer, 0);
            this.terminated = eof || this.remainingLength == 0L;
            this.sink.write(this.terminated, byteBuffer, this);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            IO.close(this.channel);
            super.onCompleteSuccess();
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            IO.close(this.channel);
            super.onCompleteFailure(x);
        }
    }
}

