/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;

public class HttpField {
    public static final QuotedStringTokenizer PARAMETER_TOKENIZER = QuotedStringTokenizer.builder().delimiters(";").ignoreOptionalWhiteSpace().allowEmbeddedQuotes().returnQuotes().build();
    public static final QuotedStringTokenizer NAME_VALUE_TOKENIZER = QuotedStringTokenizer.builder().delimiters("=").build();
    private static final String ZERO_QUALITY = "q=0";
    private final HttpHeader _header;
    private final String _name;
    private final String _value;
    private int _hash = 0;

    public HttpField(HttpHeader header, String name, String value) {
        this._header = header;
        this._name = this._header != null && name == null ? this._header.asString() : Objects.requireNonNull(name, "name");
        this._value = value != null ? value : "";
    }

    public HttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public HttpField(HttpHeader header, HttpHeaderValue value) {
        this(header, header.asString(), value != null ? value.asString() : null);
    }

    public HttpField(String name, String value) {
        this(HttpHeader.CACHE.get(name), name, value);
    }

    public static String getValueParameters(String valueParams, Map<String, String> parameters) {
        if (valueParams == null) {
            return null;
        }
        Iterator<String> tokens2 = PARAMETER_TOKENIZER.tokenize(valueParams);
        if (!tokens2.hasNext()) {
            return null;
        }
        String value = tokens2.next();
        if (parameters != null) {
            while (tokens2.hasNext()) {
                String token = tokens2.next();
                Iterator<String> nameValue = NAME_VALUE_TOKENIZER.tokenize(token);
                if (!nameValue.hasNext()) continue;
                String paramName = nameValue.next();
                String paramVal = null;
                if (nameValue.hasNext()) {
                    paramVal = nameValue.next();
                }
                parameters.put(paramName, paramVal);
            }
        }
        return value;
    }

    public static String stripParameters(String value) {
        return HttpField.getValueParameters(value, null);
    }

    @Deprecated
    public static String valueParameters(String value, Map<String, String> parameters) {
        return HttpField.getValueParameters(value, parameters);
    }

    public boolean contains(String search) {
        return HttpField.contains(this.getValue(), search);
    }

    public static boolean contains(String value, String search) {
        if (search == null) {
            return value == null;
        }
        if (search.isEmpty()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (search.equalsIgnoreCase(value)) {
            return true;
        }
        int state = 0;
        int match = 0;
        int param = 0;
        block31: for (int i = 0; i < value.length(); ++i) {
            char c = StringUtil.asciiToLowerCase(value.charAt(i));
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            match = 0;
                            state = 2;
                            continue block31;
                        }
                        case ',': {
                            continue block31;
                        }
                        case ';': {
                            param = -1;
                            match = -1;
                            state = 5;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    match = c == StringUtil.asciiToLowerCase(search.charAt(0)) ? 1 : -1;
                    state = 1;
                    continue block31;
                }
                case 1: {
                    switch (c) {
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                        case ';': {
                            param = match >= 0 ? 0 : -1;
                            state = 5;
                            continue block31;
                        }
                    }
                    if (match <= 0) continue block31;
                    if (match < search.length()) {
                        match = c == StringUtil.asciiToLowerCase(search.charAt(match)) ? match + 1 : -1;
                        continue block31;
                    }
                    if (c == ' ' || c == '\t') continue block31;
                    match = -1;
                    continue block31;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            state = 3;
                            continue block31;
                        }
                        case '\"': {
                            state = 4;
                            continue block31;
                        }
                    }
                    if (match < 0) continue block31;
                    if (match < search.length()) {
                        match = c == StringUtil.asciiToLowerCase(search.charAt(match)) ? match + 1 : -1;
                        continue block31;
                    }
                    match = -1;
                    continue block31;
                }
                case 3: {
                    if (match >= 0) {
                        match = match < search.length() ? (c == StringUtil.asciiToLowerCase(search.charAt(match)) ? match + 1 : -1) : -1;
                    }
                    state = 2;
                    continue block31;
                }
                case 4: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case ';': {
                            state = 5;
                            continue block31;
                        }
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                    }
                    match = -1;
                    continue block31;
                }
                case 5: {
                    switch (c) {
                        case ',': {
                            if (param != ZERO_QUALITY.length() && match == search.length()) {
                                return true;
                            }
                            param = 0;
                            state = 0;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    if (param < 0) continue block31;
                    if (param < ZERO_QUALITY.length()) {
                        param = c == ZERO_QUALITY.charAt(param) ? param + 1 : -1;
                        continue block31;
                    }
                    if (c == '0' || c == '.') continue block31;
                    param = -1;
                    continue block31;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return param != ZERO_QUALITY.length() && match == search.length();
    }

    public boolean containsLast(String search) {
        return HttpField.containsLast(this.getValue(), search);
    }

    public static boolean containsLast(String value, String search) {
        if (search == null) {
            return value == null;
        }
        if (search.isEmpty()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (search.equalsIgnoreCase(value)) {
            return true;
        }
        if (value.endsWith(search)) {
            int i = value.length() - search.length() - 1;
            while (i >= 0) {
                char c;
                if ((c = value.charAt(i--)) == ',') {
                    return true;
                }
                if (c == ' ') continue;
                return false;
            }
            return true;
        }
        QuotedCSV csv = new QuotedCSV(false, value);
        List<String> values = csv.getValues();
        return !values.isEmpty() && search.equalsIgnoreCase(values.get(values.size() - 1));
    }

    public int hashCode() {
        int vhc = Objects.hashCode(this.getValue());
        if (this._header == null) {
            return vhc ^ this.nameHashCode();
        }
        return vhc ^ this._header.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpField)) {
            return false;
        }
        HttpField field = (HttpField)o;
        if (this._header != field.getHeader()) {
            return false;
        }
        if (!this._name.equalsIgnoreCase(field.getName())) {
            return false;
        }
        return Objects.equals(this.getValue(), field.getValue());
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public long getLongValue() {
        return Long.parseLong(this.getValue());
    }

    public String getLowerCaseName() {
        return this._header != null ? this._header.lowerCaseName() : StringUtil.asciiToLowerCase(this._name);
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String[] getValues() {
        List<String> values = this.getValueList();
        if (values == null) {
            return null;
        }
        return (String[])values.toArray(String[]::new);
    }

    public List<String> getValueList() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        QuotedCSV list = new QuotedCSV(false, value);
        return list.getValues();
    }

    public boolean isSameName(HttpField field) {
        if (field == null) {
            return false;
        }
        if (field == this) {
            return true;
        }
        if (this._header != null && this._header == field.getHeader()) {
            return true;
        }
        return this.is(field.getName());
    }

    public boolean is(String name) {
        return this._name.equalsIgnoreCase(name);
    }

    public HttpField withoutValue(String value) {
        if (this._value.length() < value.length()) {
            return this;
        }
        if (this._value.equalsIgnoreCase(value)) {
            return null;
        }
        if (!this.contains(value)) {
            return this;
        }
        QuotedCSV csv = new QuotedCSV(false, this._value);
        Iterator<String> i = csv.iterator();
        while (i.hasNext()) {
            if (!i.next().equalsIgnoreCase(value)) continue;
            i.remove();
        }
        return new HttpField(this._header, this._name, csv.asString());
    }

    public HttpField withValue(String value) {
        if (this.contains(value)) {
            return this;
        }
        return new HttpField(this.getHeader(), this._name, this._value + "," + value);
    }

    public HttpField withValues(String ... values) {
        HttpField field = this;
        for (String value : values) {
            field = field.withValue(value);
        }
        return field;
    }

    private int nameHashCode() {
        int h = this._hash;
        int len = this._name.length();
        if (h == 0 && len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = this._name.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                h = 31 * h + c;
            }
            this._hash = h;
        }
        return h;
    }

    public String toString() {
        String v = this.getValue();
        return this.getName() + ": " + (v == null ? "" : v);
    }

    static class MultiHttpField
    extends HttpField {
        private final List<String> _list;

        public MultiHttpField(String name, List<String> list) {
            super(name, MultiHttpField.buildValue(list));
            this._list = list;
        }

        private static String buildValue(List<String> list) {
            StringBuilder builder = null;
            for (String v : list) {
                if (StringUtil.isBlank(v)) {
                    throw new IllegalArgumentException("blank element");
                }
                if (builder == null) {
                    builder = new StringBuilder(list.size() * (v == null ? 5 : v.length()) * 2);
                } else {
                    builder.append(", ");
                }
                builder.append(v);
            }
            return builder == null ? null : builder.toString();
        }

        @Override
        public List<String> getValueList() {
            return this._list;
        }

        @Override
        public boolean contains(String search) {
            for (String v : this._list) {
                if (!StringUtil.asciiEqualsIgnoreCase(v, search)) continue;
                return true;
            }
            return false;
        }
    }

    public static class LongValueHttpField
    extends HttpField {
        private final long _long;

        public LongValueHttpField(HttpHeader header, String name, String value, long longValue) {
            super(header, name, value);
            this._long = longValue;
        }

        public LongValueHttpField(HttpHeader header, String name, String value) {
            this(header, name, value, Long.parseLong(value));
        }

        public LongValueHttpField(HttpHeader header, String name, long value) {
            this(header, name, Long.toString(value), value);
        }

        public LongValueHttpField(HttpHeader header, long value) {
            this(header, header.asString(), value);
        }

        public LongValueHttpField(String header, long value) {
            this(HttpHeader.CACHE.get(header), header, value);
        }

        @Override
        public int getIntValue() {
            return Math.toIntExact(this._long);
        }

        @Override
        public long getLongValue() {
            return this._long;
        }
    }

    public static class IntValueHttpField
    extends HttpField {
        private final int _int;

        public IntValueHttpField(HttpHeader header, String name, String value, int intValue) {
            super(header, name, value);
            this._int = intValue;
        }

        public IntValueHttpField(HttpHeader header, String name, String value) {
            this(header, name, value, Integer.parseInt(value));
        }

        public IntValueHttpField(HttpHeader header, String name, int intValue) {
            this(header, name, Integer.toString(intValue), intValue);
        }

        public IntValueHttpField(HttpHeader header, int value) {
            this(header, header.asString(), value);
        }

        public IntValueHttpField(String header, int value) {
            this(HttpHeader.CACHE.get(header), header, value);
        }

        @Override
        public int getIntValue() {
            return this._int;
        }

        @Override
        public long getLongValue() {
            return this._int;
        }
    }
}

