/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.cutters.ranges;

import java.io.IOException;
import org.apache.lucene.facet.MultiDoubleValuesSource;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.util.NumericUtils;

public final class DoubleRangeFacetCutter
implements FacetCutter {
    private final LongRangeFacetCutter longRangeFacetCutter;

    public DoubleRangeFacetCutter(MultiDoubleValuesSource multiDoubleValuesSource, DoubleRange[] doubleRanges) {
        MultiLongValuesSource multiLongValuesSource;
        LongValuesSource singleLongValuesSource;
        DoubleValuesSource singleDoubleValuesSource = MultiDoubleValuesSource.unwrapSingleton(multiDoubleValuesSource);
        if (singleDoubleValuesSource != null) {
            singleLongValuesSource = singleDoubleValuesSource.toSortableLongDoubleValuesSource();
            multiLongValuesSource = null;
        } else {
            singleLongValuesSource = null;
            multiLongValuesSource = multiDoubleValuesSource.toSortableMultiLongValuesSource();
        }
        LongRange[] longRanges = this.mapDoubleRangesToSortableLong(doubleRanges);
        this.longRangeFacetCutter = LongRangeFacetCutter.createSingleOrMultiValued(multiLongValuesSource, singleLongValuesSource, longRanges);
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context2) throws IOException {
        return this.longRangeFacetCutter.createLeafCutter(context2);
    }

    private LongRange[] mapDoubleRangesToSortableLong(DoubleRange[] doubleRanges) {
        LongRange[] longRanges = new LongRange[doubleRanges.length];
        for (int i = 0; i < longRanges.length; ++i) {
            DoubleRange dr = doubleRanges[i];
            longRanges[i] = new LongRange(dr.label, NumericUtils.doubleToSortableLong(dr.min), true, NumericUtils.doubleToSortableLong(dr.max), true);
        }
        return longRanges;
    }
}

