/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene80;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.backward_codecs.lucene80.Lucene80DocValuesConsumer;
import org.apache.lucene.backward_codecs.lucene80.Lucene80DocValuesProducer;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class Lucene80DocValuesFormat
extends DocValuesFormat {
    public static final String MODE_KEY = Lucene80DocValuesFormat.class.getSimpleName() + ".mode";
    private final Mode mode;
    static final String DATA_CODEC = "Lucene80DocValuesData";
    static final String DATA_EXTENSION = "dvd";
    static final String META_CODEC = "Lucene80DocValuesMetadata";
    static final String META_EXTENSION = "dvm";
    static final int VERSION_START = 0;
    static final int VERSION_BIN_COMPRESSED = 1;
    static final int VERSION_CONFIGURABLE_COMPRESSION = 2;
    static final int VERSION_CURRENT = 2;
    static final byte NUMERIC = 0;
    static final byte BINARY = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_NUMERIC = 4;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    static final int NUMERIC_BLOCK_SHIFT = 14;
    static final int NUMERIC_BLOCK_SIZE = 16384;
    static final int BINARY_BLOCK_SHIFT = 5;
    static final int BINARY_DOCS_PER_COMPRESSED_BLOCK = 32;
    static final int TERMS_DICT_BLOCK_SHIFT = 4;
    static final int TERMS_DICT_BLOCK_SIZE = 16;
    static final int TERMS_DICT_BLOCK_MASK = 15;
    static final int TERMS_DICT_BLOCK_COMPRESSION_THRESHOLD = 32;
    static final int TERMS_DICT_BLOCK_LZ4_SHIFT = 6;
    static final int TERMS_DICT_BLOCK_LZ4_SIZE = 64;
    static final int TERMS_DICT_BLOCK_LZ4_MASK = 63;
    static final int TERMS_DICT_COMPRESSOR_LZ4_CODE = 1;
    static final int TERMS_DICT_BLOCK_LZ4_CODE = 393217;
    static final int TERMS_DICT_REVERSE_INDEX_SHIFT = 10;
    static final int TERMS_DICT_REVERSE_INDEX_SIZE = 1024;
    static final int TERMS_DICT_REVERSE_INDEX_MASK = 1023;

    public Lucene80DocValuesFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene80DocValuesFormat(Mode mode) {
        super("Lucene80");
        this.mode = Objects.requireNonNull(mode);
    }

    @Override
    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new Lucene80DocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION, this.mode);
    }

    @Override
    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new Lucene80DocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

