/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.validation.ReportEntry;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shacl.vocabulary.SHACLM;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.system.G;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class ValidationReport {
    private static ValidationReport singletonReportConformsTrue = new ValidationReport(Collections.emptySet(), Collections.emptyList(), null);
    private final Collection<ReportEntry> entries;
    private final Resource resultResource;

    public static Builder create() {
        return new Builder();
    }

    public static ValidationReport reportConformsTrue() {
        return singletonReportConformsTrue;
    }

    private ValidationReport(Set<Triple> paths, Collection<ReportEntry> entries, PrefixMapping prefixes) {
        this(entries, ValidationReport.generate(paths, entries, prefixes));
    }

    private ValidationReport(Collection<ReportEntry> entries, Resource resultResource) {
        this.entries = entries;
        this.resultResource = resultResource;
    }

    public Collection<ReportEntry> getEntries() {
        return this.entries;
    }

    public Resource getResource() {
        return this.resultResource;
    }

    public Model getModel() {
        return this.resultResource.getModel();
    }

    public Graph getGraph() {
        return this.getModel().getGraph();
    }

    public boolean conforms() {
        return this.entries.isEmpty();
    }

    private static Resource reportConformsTrueResource() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("rdf", RDF.getURI());
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("xsd", XSD.getURI());
        model.setNsPrefix("sh", SHACLM.getURI());
        Resource report = model.createResource(SHACLM.ValidationReport);
        report.addProperty(SHACLM.conforms, C.mTRUE);
        return report;
    }

    private static Resource generate(Set<Triple> paths, Collection<ReportEntry> entries, PrefixMapping prefixes) {
        if (entries.isEmpty()) {
            return ValidationReport.reportConformsTrueResource();
        }
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("rdf", RDF.getURI());
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("xsd", XSD.getURI());
        model.setNsPrefix("sh", SHACLM.getURI());
        if (prefixes != null) {
            model.setNsPrefixes(prefixes);
        }
        Resource report = model.createResource(SHACLM.ValidationReport);
        entries.forEach(e2 -> e2.generate(model, report));
        paths.forEach(model.getGraph()::add);
        report.addProperty(SHACLM.conforms, C.mFALSE);
        return report;
    }

    public static ValidationReport fromGraph(Graph graph, Node node) {
        boolean conforms = G.contains(graph, node, SHACL.conforms, C.TRUE);
        List<Node> results = G.listSP(graph, node, SHACL.result);
        if (conforms) {
            return ValidationReport.create().build();
        }
        ArrayList<ReportEntry> entries = new ArrayList<ReportEntry>();
        HashSet<Triple> paths = new HashSet<Triple>();
        for (Node r : results) {
            Node pn = ValidationReport.get(graph, r, SHACL.resultPath);
            Path path = pn != null ? ShaclPaths.parsePath(graph, pn) : null;
            ReportEntry e2 = ReportEntry.create().focusNode(ValidationReport.get(graph, r, SHACL.focusNode)).resultPath(path).message(ValidationReport.get(graph, r, SHACL.resultMessage)).severity(ValidationReport.get(graph, r, SHACL.resultSeverity)).source(ValidationReport.get(graph, r, SHACL.sourceShape)).sourceConstraint(ValidationReport.get(graph, r, SHACL.sourceConstraint)).sourceConstraintComponent(ValidationReport.get(graph, r, SHACL.sourceConstraintComponent)).detail(ValidationReport.get(graph, r, SHACL.detail)).value(ValidationReport.get(graph, r, SHACL.value));
            entries.add(e2);
        }
        return new ValidationReport(paths, entries, graph.getPrefixMapping());
    }

    private static Node get(Graph g, Node r, Node p) {
        return G.getSP(g, r, p);
    }

    public static ValidationReport fromModel(Model model) {
        return ValidationReport.fromGraph(model.getGraph());
    }

    public static ValidationReport fromGraph(Graph graph) {
        List<Node> reports = G.listPO(graph, C.rdfType, SHACL.ValidationReport);
        if (reports.isEmpty()) {
            throw new ShaclException("No report found in graph");
        }
        if (reports.size() > 1) {
            throw new ShaclException("Multiple reports found in graph");
        }
        return ValidationReport.fromGraph(graph, reports.get(0));
    }

    public static class Builder {
        private final List<ReportEntry> entries = new ArrayList<ReportEntry>();
        private final Set<Triple> paths = new HashSet<Triple>();
        private PrefixMapping prefixes = new PrefixMappingImpl();

        public void addPrefixes(PrefixMapping pmap) {
            this.prefixes.setNsPrefixes(pmap);
        }

        public void addReportEntry(ReportItem item, Shape shape, Node focusNode, Path path, Constraint constraint) {
            this.addReportEntry(item.getMessage(), shape, focusNode, path, item.getValue(), constraint);
        }

        public void addReportEntry(String message, Shape shape, Node focusNode, Path path, Node valueNode, Constraint constraint) {
            this.addReportEntryW(message, shape, null, focusNode, path, valueNode, constraint);
        }

        private void addReportEntryW(String message, Shape shape, Triple triple, Node focusNode, Path path, Node valueNode, Constraint constraint) {
            Collection<Node> messages = shape.getMessages() != null && !shape.getMessages().isEmpty() ? shape.getMessages() : Collections.singleton(NodeFactory.createLiteralString(message));
            ReportEntry e2 = ReportEntry.create().focusNode(focusNode).resultPath(path).severity(shape.getSeverity()).source(shape.getShapeNode()).constraint(constraint).value(valueNode).triple(triple);
            for (Node x : messages) {
                e2.message(x);
            }
            this.addReportEntry(e2);
        }

        public void addReportEntry(ReportEntry e2) {
            this.entries.add(e2);
        }

        public ValidationReport build() {
            return new ValidationReport(this.paths, this.entries, this.prefixes);
        }
    }
}

