/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.geosparql.geo.topological.SpatialObjectGeometryLiteral;
import org.apache.jena.geosparql.geof.topological.GenericFilterFunction;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.QueryRewriteIndex;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GenericPropertyFunction
extends PFuncSimple {
    private final GenericFilterFunction filterFunction;

    public GenericPropertyFunction(GenericFilterFunction filterFunction) {
        this.filterFunction = filterFunction;
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        if (subject.isConcrete() && object.isConcrete()) {
            return this.bothBound(binding, subject, predicate, object, execCxt);
        }
        if (subject.isVariable() && object.isVariable()) {
            return this.bothUnbound(binding, subject, predicate, object, execCxt);
        }
        return this.oneBound(binding, subject, predicate, object, execCxt);
    }

    private QueryIterator bothBound(Binding binding, boolean isSubjectBound, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        QueryIterator iter = isSubjectBound ? this.bothBound(binding, subject, predicate, object, execCxt) : this.bothBound(binding, object, predicate, subject, execCxt);
        return iter;
    }

    private QueryIterator bothBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        QueryRewriteIndex queryRewriteIndex;
        Graph graph = execCxt.getActiveGraph();
        Boolean isPositiveResult = this.queryRewrite(graph, subject, predicate, object, queryRewriteIndex = QueryRewriteIndex.retrieve(execCxt));
        if (isPositiveResult.booleanValue()) {
            return QueryIterSingleton.create(binding, execCxt);
        }
        return QueryIterNullIterator.create(execCxt);
    }

    private QueryIterator bothUnbound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        Var subjectVar = Var.alloc(subject.getName());
        Graph graph = execCxt.getActiveGraph();
        ExtendedIterator<Triple> spatialTriples = GenericPropertyFunction.findSpatialTriples(graph);
        ExtendedIterator<Binding> iterator = spatialTriples.mapWith(Triple::getSubject).mapWith(node -> BindingFactory.binding(binding, subjectVar, node));
        QueryIter queryIter = QueryIter.flatMap(QueryIterPlainWrapper.create(iterator, execCxt), b -> this.oneBound((Binding)b, b.get(subjectVar), predicate, object, execCxt), execCxt);
        return queryIter;
    }

    private QueryIterator oneBound(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        boolean isSubjectBound;
        Node unboundNode;
        Node boundNode;
        Graph graph = execCxt.getActiveGraph();
        if (subject.isConcrete()) {
            boundNode = subject;
            unboundNode = object;
            isSubjectBound = true;
        } else {
            boundNode = object;
            unboundNode = subject;
            isSubjectBound = false;
        }
        if (!(boundNode.isLiteral() || graph.contains(boundNode, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE) || graph.contains(boundNode, RDF.type.asNode(), Geo.FEATURE_NODE) || graph.contains(boundNode, RDF.type.asNode(), Geo.GEOMETRY_NODE) || graph.contains(boundNode, SpatialExtension.GEO_LAT_NODE, null))) {
            return QueryIterNullIterator.create(execCxt);
        }
        boolean isSpatialIndex = SpatialIndexLib.isDefined(execCxt);
        QueryIterator result = !isSpatialIndex || this.filterFunction.isDisjoint() || this.filterFunction.isDisconnected() ? this.findAll(graph, boundNode, unboundNode, binding, isSubjectBound, predicate, execCxt) : this.findIndex(graph, boundNode, unboundNode, binding, isSubjectBound, predicate, execCxt);
        return result;
    }

    private QueryIterator findAll(Graph graph, Node boundNode, Node unboundNode, Binding binding, boolean isSubjectBound, Node predicate, ExecutionContext execCxt) {
        Var unboundVar = Var.alloc(unboundNode.getName());
        ExtendedIterator<Triple> spatialTriples = GenericPropertyFunction.findSpatialTriples(graph);
        ExtendedIterator<Binding> iterator = spatialTriples.mapWith(Triple::getSubject).mapWith(node -> BindingFactory.binding(binding, unboundVar, node));
        return QueryIter.flatMap(QueryIterPlainWrapper.create(iterator, execCxt), b -> {
            Node spatialNode = b.get(unboundVar);
            QueryIterator iter = this.bothBound((Binding)b, isSubjectBound, boundNode, predicate, spatialNode, execCxt);
            return iter;
        }, execCxt);
    }

    private static ExtendedIterator<Triple> findSpatialTriples(Graph graph) {
        ExtendedIterator<Triple> spatialTriples;
        if (graph.contains(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE)) {
            spatialTriples = graph.find(null, RDF.type.asNode(), Geo.SPATIAL_OBJECT_NODE);
        } else if (graph.contains(null, RDF.type.asNode(), Geo.FEATURE_NODE) || graph.contains(null, RDF.type.asNode(), Geo.GEOMETRY_NODE)) {
            ExtendedIterator<Triple> featureTriples = graph.find(null, RDF.type.asNode(), Geo.FEATURE_NODE);
            ExtendedIterator<Triple> geometryTriples = graph.find(null, RDF.type.asNode(), Geo.GEOMETRY_NODE);
            spatialTriples = featureTriples.andThen(geometryTriples);
        } else {
            spatialTriples = graph.find(null, SpatialExtension.GEO_LAT_NODE, null);
        }
        return spatialTriples;
    }

    private QueryIterator findIndex(Graph graph, Node boundNode, Node unboundNode, Binding binding, boolean isSubjectBound, Node predicate, ExecutionContext execCxt) throws ExprEvalException {
        try {
            Var unboundVar = Var.alloc(unboundNode);
            List assertedNodes = !isSubjectBound || !boundNode.isLiteral() ? this.findAsserted(graph, boundNode, isSubjectBound, predicate) : List.of();
            QueryIterator assertedNodesIter = QueryIterPlainWrapper.create(Iter.map(assertedNodes.iterator(), node -> BindingFactory.binding(binding, unboundVar, node)), execCxt);
            SpatialObjectGeometryLiteral boundGeometryLiteral = SpatialObjectGeometryLiteral.retrieve(graph, boundNode);
            if (!boundGeometryLiteral.isValid()) {
                return assertedNodesIter;
            }
            QueryIterConcat queryIterConcat = new QueryIterConcat(execCxt);
            queryIterConcat.add(assertedNodesIter);
            Node geometryLiteral = boundGeometryLiteral.getGeometryLiteral();
            SpatialIndex spatialIndex = SpatialIndexLib.retrieve(execCxt);
            GeometryWrapper geom = GeometryWrapper.extract(geometryLiteral);
            GeometryWrapper transformedGeom = geom.transform(spatialIndex.getSrsInfo());
            Envelope searchEnvelope = transformedGeom.getEnvelope();
            Node graphName = SpatialIndexLib.unwrapGraphName(graph);
            Collection<Node> features = spatialIndex.query(searchEnvelope, graphName);
            QueryIterator featuresIter = QueryIterPlainWrapper.create(Iter.map(features.iterator(), feature -> BindingFactory.binding(binding, unboundVar, feature)), execCxt);
            QueryIter queryIterator = QueryIter.flatMap(featuresIter, featureBinding -> this.findByFeature(graph, binding, (Binding)featureBinding, isSubjectBound, boundNode, predicate, unboundVar, execCxt, assertedNodes), execCxt);
            queryIterConcat.add(queryIterator);
            return queryIterConcat;
        }
        catch (SpatialIndexException | MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + FmtUtils.stringForNode(boundNode) + ", " + FmtUtils.stringForNode(unboundNode) + ", " + FmtUtils.stringForNode(predicate), ex);
        }
    }

    private QueryIterator findByFeature(Graph graph, Binding binding, Binding featureBinding, boolean isSubjectBound, Node boundNode, Node predicate, Var unboundVar, ExecutionContext execCxt, Collection<Node> assertedNodes) {
        Node featureNode = featureBinding.get(unboundVar);
        QueryIterConcat featureIterConcat = new QueryIterConcat(execCxt);
        if (!assertedNodes.contains(featureNode)) {
            QueryIterator tmpIter = this.bothBound(featureBinding, isSubjectBound, boundNode, predicate, featureNode, execCxt);
            featureIterConcat.add(tmpIter);
        }
        ExtendedIterator<Node> featureGeometries = G.iterSP(graph, featureNode, Geo.HAS_GEOMETRY_NODE);
        QueryIterator geometriesQueryIterator = QueryIterPlainWrapper.create(Iter.map(Iter.filter(featureGeometries, geometry -> !assertedNodes.contains(geometry)), geometryNode -> BindingFactory.binding(binding, unboundVar, geometryNode)), execCxt);
        geometriesQueryIterator = QueryIter.flatMap(geometriesQueryIterator, b2 -> {
            Node geomNode = b2.get(unboundVar);
            return this.bothBound((Binding)b2, isSubjectBound, boundNode, predicate, geomNode, execCxt);
        }, execCxt);
        featureIterConcat.add(geometriesQueryIterator);
        return featureIterConcat;
    }

    private List<Node> findAsserted(Graph graph, Node boundNode, boolean isSubjectBound, Node predicate) {
        List<Node> assertedNodes = isSubjectBound ? G.listSP(graph, boundNode, predicate) : G.listPO(graph, predicate, boundNode);
        return assertedNodes;
    }

    protected final Boolean queryRewrite(Graph graph, Node subject, Node predicate, Node object, QueryRewriteIndex queryRewriteIndex) {
        if (graph.contains(subject, predicate, object)) {
            return true;
        }
        if (!queryRewriteIndex.isIndexActive()) {
            return false;
        }
        SpatialObjectGeometryLiteral subjectSpatialLiteral = SpatialObjectGeometryLiteral.retrieve(graph, subject);
        if (!subjectSpatialLiteral.isValid()) {
            return false;
        }
        SpatialObjectGeometryLiteral objectSpatialLiteral = SpatialObjectGeometryLiteral.retrieve(graph, object);
        if (!objectSpatialLiteral.isValid()) {
            return false;
        }
        Boolean isPositive = queryRewriteIndex.test(subjectSpatialLiteral.getGeometryLiteral(), predicate, objectSpatialLiteral.getGeometryLiteral(), this);
        return isPositive;
    }

    public Boolean testFilterFunction(Node subjectGeometryLiteral, Node objectGeometryLiteral) {
        return this.filterFunction.exec(subjectGeometryLiteral, objectGeometryLiteral);
    }
}

