/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod;

import java.net.BindException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.FusekiMain;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.FusekiServerArgsCustomiser;
import org.apache.jena.fuseki.mod.admin.FMod_Admin;
import org.apache.jena.fuseki.mod.prometheus.FMod_Prometheus;
import org.apache.jena.fuseki.mod.shiro.FMod_Shiro;
import org.apache.jena.fuseki.mod.ui.FMod_UI;

public class FusekiServerRunner {
    public static void main(String ... args) {
        FusekiServerRunner.prepareFusekiMain();
        FusekiMain.run(args);
    }

    public static FusekiServer runAsync(String ... args) {
        FusekiServer server = FusekiServerRunner.construct(args);
        try {
            return server.start();
        }
        catch (FusekiException ex) {
            if (ex.getCause() instanceof BindException) {
                Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port in use");
                System.exit(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
    }

    public static FusekiServer construct(String ... args) {
        FusekiServerRunner.prepareFusekiMain();
        FusekiServer server = FusekiServer.construct(args);
        FusekiServerRunner.resetFusekiMain();
        return server;
    }

    private static void prepareFusekiMain() {
        String fusekiBase = Lib.getenv("FUSEKI_BASE");
        if (fusekiBase == null) {
            fusekiBase = "run";
        }
        FileOps.ensureDir(fusekiBase);
        final FusekiModules serverModules = FusekiServerRunner.serverModules();
        FusekiServerArgsCustomiser initializeServerArgs = new FusekiServerArgsCustomiser(){

            @Override
            public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
                serverArgs.allowEmpty = true;
                serverArgs.fusekiModules = serverModules;
            }
        };
        FusekiMain.resetCustomisers();
        FusekiMain.addCustomiser(initializeServerArgs);
        serverModules.forEach(FusekiMain::addCustomiser);
    }

    private static void resetFusekiMain() {
        FusekiMain.resetCustomisers();
    }

    public static FusekiModules serverModules() {
        FMod_Shiro fmodShiro = FMod_Shiro.create();
        FMod_Admin fmodAdmin = FMod_Admin.create();
        FusekiModule fmodUI = FMod_UI.create();
        FusekiModule fmodPrometheus = FMod_Prometheus.create();
        FusekiModules serverModules = FusekiModules.create(fmodAdmin, fmodUI, fmodShiro, fmodPrometheus);
        return serverModules;
    }
}

