/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jsonld.deseralization.RdfTripleConsumer;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import java.util.HashMap;
import java.util.Map;

public abstract class RdfQuadAdapter
implements RdfQuadConsumer,
RdfTripleConsumer {
    protected final Map<String, RdfResource> resources;
    protected RdfResource graphName;

    public RdfQuadAdapter() {
        this(new HashMap<String, RdfResource>());
    }

    public RdfQuadAdapter(Map<String, RdfResource> resources) {
        this.resources = resources;
        this.graphName = null;
    }

    protected abstract void quad(RdfResource var1, RdfResource var2, RdfValue var3, RdfResource var4);

    @Override
    public RdfQuadAdapter namedGraph(String graph) {
        this.graphName = this.getResource(graph);
        return this;
    }

    @Override
    public RdfQuadAdapter defaultGraph() {
        this.graphName = null;
        return this;
    }

    @Override
    public RdfQuadAdapter triple(String subject, String predicate, String literal, String language, String direction) {
        this.quad(this.getResource(subject), this.getResource(predicate), Rdf.createLangString(literal, language, direction), this.graphName);
        return this;
    }

    @Override
    public RdfQuadAdapter triple(String subject, String predicate, String literal, String datatype) {
        this.quad(this.getResource(subject), this.getResource(predicate), Rdf.createTypedString(literal, datatype), this.graphName);
        return this;
    }

    @Override
    public RdfQuadAdapter triple(String subject, String predicate, String object) {
        this.quad(this.getResource(subject), this.getResource(predicate), this.getResource(object), this.graphName);
        return this;
    }

    @Override
    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
        RdfValue objectValue = language != null ? Rdf.createLangString(object, language, direction) : (datatype != null ? Rdf.createTypedString(object, datatype) : this.getResource(object));
        this.quad(this.getResource(subject), this.getResource(predicate), objectValue, this.getResource(graph));
        return this;
    }

    protected final RdfResource getResource(String name) {
        return name != null ? this.resources.computeIfAbsent(name, arg0 -> name.startsWith("_:") ? Rdf.createBlankNode(name) : Rdf.createIRI(name)) : null;
    }
}

