/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.service.RSocketRequestValues;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class MetadataArgumentResolver
implements RSocketServiceArgumentResolver {
    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, RSocketRequestValues.Builder requestValues) {
        int index = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        if (parameter.getParameterType().equals(MimeType.class)) {
            Assert.notNull((Object)argument, (String)"MimeType parameter is required");
            Assert.state((index > 0 ? 1 : 0) != 0, (String)"MimeType parameter should have preceding metadata object parameter");
            requestValues.addMimeType((MimeType)argument);
            return true;
        }
        if (paramTypes.length > index + 1 && MimeType.class.equals(paramTypes[index + 1])) {
            Assert.notNull((Object)argument, (String)"MimeType parameter is required");
            requestValues.addMetadata(argument);
            return true;
        }
        return false;
    }
}

