/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

public class SimpleRegex {
    private final String expr;
    private final boolean caseInsensitive;

    public SimpleRegex(String expr, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.expr = caseInsensitive ? expr.toLowerCase() : expr;
    }

    public boolean matches(String target) {
        if (this.caseInsensitive) {
            target = target.toLowerCase();
        }
        boolean mobile = false;
        int exprPos = 0;
        int targetPos = 0;
        while (true) {
            int star;
            if ((star = this.expr.indexOf(".*", exprPos)) == exprPos) {
                mobile = true;
                exprPos += 2;
                continue;
            }
            if (star == -1) {
                int len = this.expr.length() - exprPos;
                if (!mobile && targetPos != target.length() - len) {
                    return false;
                }
                if (target.length() < len) {
                    return false;
                }
                int match = this.indexOf(target, target.length() - len, exprPos, len, true);
                return match != -1;
            }
            int match = this.indexOf(target, targetPos, exprPos, star - exprPos, !mobile);
            if (match == -1) {
                return false;
            }
            targetPos = match + star - exprPos;
            exprPos = star + 2;
            mobile = true;
        }
    }

    private int indexOf(String target, int targetStart, int exprStart, int exprLength, boolean beginOnly) {
        while (target.length() - targetStart >= exprLength) {
            boolean found = true;
            for (int i = 0; i < exprLength; ++i) {
                if (this.expr.charAt(exprStart + i) == '.' || this.expr.charAt(exprStart + i) == target.charAt(targetStart + i)) continue;
                found = false;
                break;
            }
            if (found) {
                return targetStart;
            }
            if (beginOnly) {
                return -1;
            }
            ++targetStart;
        }
        return -1;
    }
}

