/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.PasswordExpiredControl;
import com.unboundid.ldap.sdk.controls.PasswordExpiringControl;
import com.unboundid.ldap.sdk.experimental.DraftBeheraLDAPPasswordPolicy10ResponseControl;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordExpirationLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck {
    @NotNull
    private final AtomicLong lastWarningTime = new AtomicLong(0L);
    @Nullable
    private final Long millisBetweenRepeatWarnings;
    @Nullable
    private final OutputStream outputStream;
    @Nullable
    private final Writer writer;

    public PasswordExpirationLDAPConnectionPoolHealthCheck() {
        this(null, null, null);
    }

    public PasswordExpirationLDAPConnectionPoolHealthCheck(@Nullable OutputStream outputStream) {
        this(outputStream, null, null);
    }

    public PasswordExpirationLDAPConnectionPoolHealthCheck(@Nullable Writer writer) {
        this(null, writer, null);
    }

    public PasswordExpirationLDAPConnectionPoolHealthCheck(@Nullable OutputStream outputStream, @Nullable Long millisBetweenRepeatWarnings) {
        this(outputStream, null, millisBetweenRepeatWarnings);
    }

    public PasswordExpirationLDAPConnectionPoolHealthCheck(@Nullable Writer writer, @Nullable Long millisBetweenRepeatWarnings) {
        this(null, writer, millisBetweenRepeatWarnings);
    }

    private PasswordExpirationLDAPConnectionPoolHealthCheck(@Nullable OutputStream outputStream, @Nullable Writer writer, @Nullable Long millisBetweenRepeatWarnings) {
        this.outputStream = outputStream;
        this.writer = writer;
        this.millisBetweenRepeatWarnings = millisBetweenRepeatWarnings;
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
        long millisSinceLastWarning;
        PasswordExpiredControl expiredControl = PasswordExpiredControl.get(bindResult);
        if (expiredControl != null) {
            if (bindResult.getResultCode() == ResultCode.SUCCESS) {
                throw new LDAPException(ResultCode.ADMIN_LIMIT_EXCEEDED, LDAPMessages.ERR_PW_EXP_WITH_SUCCESS.get());
            }
            if (bindResult.getDiagnosticMessage() == null) {
                throw new LDAPException(bindResult.getResultCode(), LDAPMessages.ERR_PW_EXP_WITH_FAILURE_NO_MSG.get());
            }
            throw new LDAPException(bindResult.getResultCode(), LDAPMessages.ERR_PW_EXP_WITH_FAILURE_WITH_MSG.get(bindResult.getDiagnosticMessage()));
        }
        DraftBeheraLDAPPasswordPolicy10ResponseControl pwPolicyControl = DraftBeheraLDAPPasswordPolicy10ResponseControl.get(bindResult);
        if (pwPolicyControl != null && pwPolicyControl.getErrorType() != null) {
            ResultCode resultCode = bindResult.getResultCode() == ResultCode.SUCCESS ? ResultCode.ADMIN_LIMIT_EXCEEDED : bindResult.getResultCode();
            String message = bindResult.getDiagnosticMessage() == null ? LDAPMessages.ERR_PW_POLICY_ERROR_NO_MSG.get(pwPolicyControl.getErrorType().toString()) : LDAPMessages.ERR_PW_POLICY_ERROR_WITH_MSG.get(pwPolicyControl.getErrorType().toString(), bindResult.getDiagnosticMessage());
            throw new LDAPException(resultCode, message);
        }
        if (this.millisBetweenRepeatWarnings == null ? !this.lastWarningTime.compareAndSet(0L, System.currentTimeMillis()) : this.millisBetweenRepeatWarnings > 0L && (millisSinceLastWarning = System.currentTimeMillis() - this.lastWarningTime.get()) < this.millisBetweenRepeatWarnings) {
            return;
        }
        String message = null;
        if (pwPolicyControl != null && pwPolicyControl.getWarningType() != null) {
            switch (pwPolicyControl.getWarningType()) {
                case TIME_BEFORE_EXPIRATION: {
                    message = LDAPMessages.WARN_PW_EXPIRING.get(StaticUtils.secondsToHumanReadableDuration(pwPolicyControl.getWarningValue()));
                    break;
                }
                case GRACE_LOGINS_REMAINING: {
                    message = LDAPMessages.WARN_PW_POLICY_GRACE_LOGIN.get(pwPolicyControl.getWarningValue());
                }
            }
        }
        PasswordExpiringControl expiringControl = PasswordExpiringControl.get(bindResult);
        if (message == null && expiringControl != null) {
            message = LDAPMessages.WARN_PW_EXPIRING.get(StaticUtils.secondsToHumanReadableDuration(expiringControl.getSecondsUntilExpiration()));
        }
        if (message != null) {
            this.warn(message);
        }
    }

    private void warn(@NotNull String message) throws LDAPException {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(StaticUtils.getBytes(message + StaticUtils.EOL));
                this.outputStream.flush();
                this.lastWarningTime.set(System.currentTimeMillis());
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (this.writer != null) {
            try {
                this.writer.write(message + StaticUtils.EOL);
                this.writer.flush();
                this.lastWarningTime.set(System.currentTimeMillis());
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else {
            this.lastWarningTime.set(System.currentTimeMillis());
            throw new LDAPException(ResultCode.ADMIN_LIMIT_EXCEEDED, message);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("WarnAboutPasswordExpirationLDAPConnectionPoolHealthCheck(");
        buffer.append("throwExceptionOnWarning=");
        buffer.append(this.outputStream == null && this.writer == null);
        if (this.millisBetweenRepeatWarnings == null) {
            buffer.append(", suppressSubsequentWarnings=true");
        } else if (this.millisBetweenRepeatWarnings > 0L) {
            buffer.append(", millisBetweenRepeatWarnings=");
            buffer.append(this.millisBetweenRepeatWarnings);
        } else {
            buffer.append(", suppressSubsequentWarnings=false");
        }
        buffer.append(')');
    }
}

