/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

public class BM25Similarity
extends Similarity {
    private final float k1;
    private final float b;
    private static final float[] LENGTH_TABLE = new float[256];

    public BM25Similarity(float k1, float b, boolean discountOverlaps) {
        super(discountOverlaps);
        if (!Float.isFinite(k1) || k1 < 0.0f) {
            throw new IllegalArgumentException("illegal k1 value: " + k1 + ", must be a non-negative finite value");
        }
        if (Float.isNaN(b) || b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("illegal b value: " + b + ", must be between 0 and 1");
        }
        this.k1 = k1;
        this.b = b;
    }

    public BM25Similarity(float k1, float b) {
        this(k1, b, true);
    }

    public BM25Similarity(boolean discountOverlaps) {
        this(1.2f, 0.75f, discountOverlaps);
    }

    public BM25Similarity() {
        this(1.2f, 0.75f, true);
    }

    protected float idf(long docFreq, long docCount) {
        return (float)Math.log(1.0 + ((double)(docCount - docFreq) + 0.5) / ((double)docFreq + 0.5));
    }

    protected float avgFieldLength(CollectionStatistics collectionStats) {
        return (float)((double)collectionStats.sumTotalTermFreq() / (double)collectionStats.docCount());
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match((Number)Float.valueOf(idf), "idf, computed as log(1 + (N - n + 0.5) / (n + 0.5)) from:", Explanation.match((Number)df, "n, number of documents containing term", new Explanation[0]), Explanation.match((Number)docCount, "N, total number of documents with field", new Explanation[0]));
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        double idf = 0.0;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            details.add(idfExplain);
            idf += (double)idfExplain.getValue().floatValue();
        }
        return Explanation.match((Number)Float.valueOf((float)idf), "idf, sum of:", details);
    }

    @Override
    public final Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float avgdl = this.avgFieldLength(collectionStats);
        float[] cache = new float[256];
        for (int i = 0; i < cache.length; ++i) {
            cache[i] = 1.0f / (this.k1 * (1.0f - this.b + this.b * LENGTH_TABLE[i] / avgdl));
        }
        return new BM25Scorer(boost, this.k1, this.b, idf, avgdl, cache);
    }

    public String toString() {
        return "BM25(k1=" + this.k1 + ",b=" + this.b + ")";
    }

    public final float getK1() {
        return this.k1;
    }

    public final float getB() {
        return this.b;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BM25Similarity.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)i);
        }
    }

    private static class BM25Scorer
    extends Similarity.SimScorer {
        private final float boost;
        private final float k1;
        private final float b;
        private final Explanation idf;
        private final float avgdl;
        private final float[] cache;
        private final float weight;

        BM25Scorer(float boost, float k1, float b, Explanation idf, float avgdl, float[] cache) {
            this.boost = boost;
            this.idf = idf;
            this.avgdl = avgdl;
            this.k1 = k1;
            this.b = b;
            this.cache = cache;
            this.weight = boost * idf.getValue().floatValue();
        }

        @Override
        public float score(float freq, long encodedNorm) {
            float normInverse = this.cache[(byte)encodedNorm & 0xFF];
            return this.weight - this.weight / (1.0f + freq * normInverse);
        }

        @Override
        public Explanation explain(Explanation freq, long encodedNorm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>(this.explainConstantFactors());
            Explanation tfExpl = this.explainTF(freq, encodedNorm);
            subs.add(tfExpl);
            float normInverse = this.cache[(byte)encodedNorm & 0xFF];
            return Explanation.match((Number)Float.valueOf(this.weight - this.weight / (1.0f + freq.getValue().floatValue() * normInverse)), "score(freq=" + String.valueOf(freq.getValue()) + "), computed as boost * idf * tf from:", subs);
        }

        private Explanation explainTF(Explanation freq, long norm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            subs.add(freq);
            subs.add(Explanation.match((Number)Float.valueOf(this.k1), "k1, term saturation parameter", new Explanation[0]));
            float doclen = LENGTH_TABLE[(byte)norm & 0xFF];
            subs.add(Explanation.match((Number)Float.valueOf(this.b), "b, length normalization parameter", new Explanation[0]));
            if ((norm & 0xFFL) > 39L) {
                subs.add(Explanation.match((Number)Float.valueOf(doclen), "dl, length of field (approximate)", new Explanation[0]));
            } else {
                subs.add(Explanation.match((Number)Float.valueOf(doclen), "dl, length of field", new Explanation[0]));
            }
            subs.add(Explanation.match((Number)Float.valueOf(this.avgdl), "avgdl, average length of field", new Explanation[0]));
            float normInverse = 1.0f / (this.k1 * (1.0f - this.b + this.b * doclen / this.avgdl));
            return Explanation.match((Number)Float.valueOf(1.0f - 1.0f / (1.0f + freq.getValue().floatValue() * normInverse)), "tf, computed as freq / (freq + k1 * (1 - b + b * dl / avgdl)) from:", subs);
        }

        private List<Explanation> explainConstantFactors() {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            if (this.boost != 1.0f) {
                subs.add(Explanation.match((Number)Float.valueOf(this.boost), "boost", new Explanation[0]));
            }
            subs.add(this.idf);
            return subs;
        }
    }
}

