/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Store;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.FolderProcessor;
import org.apache.james.fetchmail.ProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreProcessor
extends ProcessorAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreProcessor.class);

    protected StoreProcessor(Account account) {
        super(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void process() throws MessagingException {
        block16: {
            Store store = null;
            LOGGER.info("Starting fetching mail from server '{}' for user '{}' in folder '{}'", new Object[]{this.getHost(), this.getUser(), this.getJavaMailFolderName()});
            store = this.getSession().getStore(this.getJavaMailProviderName());
            if (this.getHost() != null || this.getUser() != null || this.getPassword() != null) {
                store.connect(this.getHost(), this.getUser(), this.getPassword());
            } else {
                store.connect();
            }
            Folder folder = store.getFolder(this.getJavaMailFolderName());
            if (folder == null) {
                LOGGER.error("{} No default folder", (Object)this.getFetchTaskName());
            }
            new FolderProcessor(folder, this.getAccount()).process();
            try {
                if (null != store && store.isConnected()) {
                    store.close();
                }
            }
            catch (MessagingException ex) {
                LOGGER.error("A MessagingException occured while closing the Store", (Throwable)ex);
            }
            LOGGER.info("Finished fetching mail from server '{}' for user '{}' in folder '{}'", new Object[]{this.getHost(), this.getUser(), this.getJavaMailFolderName()});
            break block16;
            catch (MessagingException ex) {
                try {
                    LOGGER.error("A MessagingException has terminated processing of this Folder", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (null != store && store.isConnected()) {
                            store.close();
                        }
                    }
                    catch (MessagingException ex2) {
                        LOGGER.error("A MessagingException occured while closing the Store", (Throwable)ex2);
                    }
                    LOGGER.info("Finished fetching mail from server '{}' for user '{}' in folder '{}'", new Object[]{this.getHost(), this.getUser(), this.getJavaMailFolderName()});
                    throw throwable;
                }
                try {
                    if (null != store && store.isConnected()) {
                        store.close();
                    }
                }
                catch (MessagingException ex3) {
                    LOGGER.error("A MessagingException occured while closing the Store", (Throwable)ex3);
                }
                LOGGER.info("Finished fetching mail from server '{}' for user '{}' in folder '{}'", new Object[]{this.getHost(), this.getUser(), this.getJavaMailFolderName()});
            }
        }
    }
}

