/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.utils.GuiceProbe;

public class MessageIdProbe
implements GuiceProbe {
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;

    @Inject
    public MessageIdProbe(MailboxManager mailboxManager, MessageIdManager messageIdManager) {
        this.mailboxManager = mailboxManager;
        this.messageIdManager = messageIdManager;
    }

    public List<MessageResult> getMessages(MessageId messageId, Username user) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(user);
        return this.messageIdManager.getMessage(messageId, FetchGroup.FULL_CONTENT, mailboxSession);
    }

    public void updateNewFlags(Username user, Flags newFlags, MessageId messageId, List<MailboxId> mailboxIds) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(user);
        this.messageIdManager.setFlags(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, mailboxIds, mailboxSession);
    }

    public List<AttachmentId> retrieveAttachmentIds(MessageId messageId, Username username) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        List messages = this.messageIdManager.getMessage(messageId, FetchGroup.FULL_CONTENT, mailboxSession);
        return (List)messages.stream().flatMap(Throwing.function(messageResult -> messageResult.getLoadedAttachments().stream())).map(MessageAttachmentMetadata::getAttachmentId).collect(ImmutableList.toImmutableList());
    }
}

