/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.vault.search.Query;
import org.apache.james.webadmin.vault.routes.RestoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedMessagesVaultRestoreTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"deleted-messages-restore");
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedMessagesVaultRestoreTask.class);
    private final Username userToRestore;
    private final RestoreService vaultRestore;
    private final AtomicLong successfulRestoreCount;
    private final AtomicLong errorRestoreCount;
    @VisibleForTesting
    final Query query;

    public DeletedMessagesVaultRestoreTask(RestoreService vaultRestore, Username userToRestore, Query query) {
        this.query = query;
        this.userToRestore = userToRestore;
        this.vaultRestore = vaultRestore;
        this.successfulRestoreCount = new AtomicLong();
        this.errorRestoreCount = new AtomicLong();
    }

    public Task.Result run() {
        try {
            return this.vaultRestore.restore(this.userToRestore, this.query).toStream().peek(this::updateInformation).map(this::restoreResultToTaskResult).reduce(Task::combine).orElse(Task.Result.COMPLETED);
        }
        catch (MailboxException e) {
            LOGGER.error("Error happens while restoring user {}", (Object)this.userToRestore.asString(), (Object)e);
            return Task.Result.PARTIAL;
        }
    }

    private Task.Result restoreResultToTaskResult(RestoreService.RestoreResult restoreResult) {
        if (restoreResult.equals((Object)RestoreService.RestoreResult.RESTORE_SUCCEED)) {
            return Task.Result.COMPLETED;
        }
        return Task.Result.PARTIAL;
    }

    private void updateInformation(RestoreService.RestoreResult restoreResult) {
        switch (restoreResult) {
            case RESTORE_FAILED: {
                this.incrementErrorRestoreCount();
                break;
            }
            case RESTORE_SUCCEED: {
                this.incrementSuccessfulRestoreCount();
            }
        }
    }

    private void incrementSuccessfulRestoreCount() {
        this.successfulRestoreCount.incrementAndGet();
    }

    private void incrementErrorRestoreCount() {
        this.errorRestoreCount.incrementAndGet();
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.userToRestore, this.successfulRestoreCount.get(), this.errorRestoreCount.get(), Clock.systemUTC().instant()));
    }

    Username getUserToRestore() {
        return this.userToRestore;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username username;
        private final long successfulRestoreCount;
        private final long errorRestoreCount;
        private final Instant timestamp;

        AdditionalInformation(Username username, long successfulRestoreCount, long errorRestoreCount, Instant timestamp) {
            this.username = username;
            this.successfulRestoreCount = successfulRestoreCount;
            this.errorRestoreCount = errorRestoreCount;
            this.timestamp = timestamp;
        }

        public long getSuccessfulRestoreCount() {
            return this.successfulRestoreCount;
        }

        public long getErrorRestoreCount() {
            return this.errorRestoreCount;
        }

        public String getUsername() {
            return this.username.asString();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

