/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.metadata;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.types.Type;

public final class GravitinoColumn {
    private final String name;
    private final Type dataType;
    private final int index;
    private final String comment;
    private final boolean nullable;
    private final boolean autoIncrement;
    private final Map<String, Object> properties;

    public GravitinoColumn(Column column, int columnIndex) {
        this(column.name(), column.dataType(), columnIndex, column.comment(), column.nullable(), column.autoIncrement(), (Map<String, Object>)ImmutableMap.of());
    }

    public GravitinoColumn(String name, Type dataType, int index, String comment, boolean nullable, boolean autoIncrement, Map<String, Object> properties) {
        this.name = name;
        this.dataType = dataType;
        this.index = index;
        this.comment = comment;
        this.nullable = nullable;
        this.autoIncrement = autoIncrement;
        this.properties = properties;
    }

    public GravitinoColumn(String name, Type dataType, int index, String comment, boolean nullable) {
        this(name, dataType, index, comment, nullable, false, (Map<String, Object>)ImmutableMap.of());
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.dataType;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }
}

