/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.tag;

import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface TagChange {
    public static TagChange rename(String newName) {
        return new RenameTag(newName);
    }

    public static TagChange updateComment(String newComment) {
        return new UpdateTagComment(newComment);
    }

    public static TagChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static TagChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class RemoveProperty
    implements TagChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty removeProperty = (RemoveProperty)o;
            return this.property.equals(removeProperty.property);
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        public String toString() {
            return "REMOVETAGPROPERTY " + this.property;
        }
    }

    public static final class SetProperty
    implements TagChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty setProperty = (SetProperty)o;
            return this.property.equals(setProperty.property) && this.value.equals(setProperty.value);
        }

        public int hashCode() {
            return this.property.hashCode() + this.value.hashCode();
        }

        public String toString() {
            return "SETTAGPROPERTY " + this.property + " = " + this.value;
        }
    }

    public static final class UpdateTagComment
    implements TagChange {
        private final String newComment;

        private UpdateTagComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateTagComment updateTagComment = (UpdateTagComment)o;
            return this.newComment.equals(updateTagComment.newComment);
        }

        public int hashCode() {
            return this.newComment.hashCode();
        }

        public String toString() {
            return "UPDATETAGCOMMENT " + this.newComment;
        }
    }

    public static final class RenameTag
    implements TagChange {
        private final String newName;

        private RenameTag(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameTag renameTag = (RenameTag)o;
            return this.newName.equals(renameTag.newName);
        }

        public int hashCode() {
            return this.newName.hashCode();
        }

        public String toString() {
            return "RENAMETAG " + this.newName;
        }
    }
}

