/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

public enum LockMode {
    NL,
    IS,
    IX,
    S,
    SIX,
    X;

    private static final boolean[][] COMPAT_MATRIX;
    private static final boolean[][] REENTER_MATRIX;
    private static final LockMode[][] UPGRADE_MATRIX;

    public boolean isCompatible(LockMode lockMode) {
        return COMPAT_MATRIX[this.ordinal()][lockMode.ordinal()];
    }

    public boolean allowReenter(LockMode lockMode) {
        return REENTER_MATRIX[this.ordinal()][lockMode.ordinal()];
    }

    public static LockMode supremum(LockMode lockMode1, LockMode lockMode2) {
        return UPGRADE_MATRIX[lockMode1.ordinal()][lockMode2.ordinal()];
    }

    static {
        COMPAT_MATRIX = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, true, false}, {true, true, true, false, false, false}, {true, true, false, true, false, false}, {true, true, false, false, false, false}, {true, false, false, false, false, false}};
        REENTER_MATRIX = new boolean[][]{{true, false, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, false, false, false}, {true, true, false, true, false, false}, {true, true, true, true, true, false}, {true, true, true, true, true, true}};
        UPGRADE_MATRIX = new LockMode[][]{{NL, IS, IX, S, SIX, X}, {IS, IS, IX, S, SIX, X}, {IX, IX, IX, SIX, SIX, X}, {S, S, SIX, S, SIX, X}, {SIX, SIX, SIX, SIX, SIX, X}, {X, X, X, X, X, X}};
    }
}

