/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.config.InterceptUrlPatternModifier;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.rules.InterceptUrlMapRule;
import io.micronaut.security.rules.SensitiveEndpointRule;
import io.micronaut.security.token.RolesFinder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class ConfigurationInterceptUrlMapRule
extends InterceptUrlMapRule {
    public static final Integer ORDER = SensitiveEndpointRule.ORDER - 100;
    private final List<InterceptUrlMapPattern> patternList;

    @Inject
    public ConfigurationInterceptUrlMapRule(RolesFinder rolesFinder, SecurityConfiguration securityConfiguration, InterceptUrlPatternModifier interceptUrlPatternModifier) {
        super(rolesFinder);
        this.patternList = securityConfiguration.getInterceptUrlMap().stream().map(interceptUrlPatternModifier::modify).collect(Collectors.toList());
    }

    @Deprecated
    public ConfigurationInterceptUrlMapRule(RolesFinder rolesFinder, SecurityConfiguration securityConfiguration) {
        this(rolesFinder, securityConfiguration, interceptUrlMapPattern -> interceptUrlMapPattern);
    }

    @Override
    protected List<InterceptUrlMapPattern> getPatternList() {
        return this.patternList;
    }

    public int getOrder() {
        return ORDER;
    }
}

