/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.ssl;

import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.util.Tokenizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TLSTest {
    TLSTest() {
    }

    @Test
    void isSame() throws ParseException {
        Assertions.assertTrue((boolean)TLS.V_1_0.isSame(TLS.parse((String)"TLSv1")));
    }

    @Test
    void isComparable() throws ParseException {
        Assertions.assertTrue((boolean)TLS.V_1_0.isComparable(TLS.parse((String)"TLSv1")));
    }

    @Test
    void greaterEquals() throws ParseException {
        Assertions.assertTrue((boolean)TLS.V_1_3.greaterEquals(TLS.parse((String)"TLSv1")));
    }

    @Test
    void lessEquals() throws ParseException {
        Assertions.assertTrue((boolean)TLS.V_1_0.lessEquals(TLS.parse((String)"TLSv1.3")));
    }

    @Test
    void parse() throws ParseException {
        Assertions.assertTrue((boolean)TLS.V_1_0.lessEquals(TLS.parse((String)"TLSv1.3")));
    }

    @Test
    void parseNull() throws ParseException {
        Assertions.assertNull((Object)TLS.parse(null));
    }

    @Test
    void excludeWeakNull() {
        Assertions.assertNull((Object)TLS.excludeWeak((String[])null));
    }

    @Test
    void excludeWeak() {
        String[] strongProtocols;
        String[] mixProtocol = new String[]{"SSL 2.0", "TLS 1.3", "SSL 3.0", "TLS 1.2", "TLS 1.1"};
        for (String protocol : strongProtocols = TLS.excludeWeak((String[])mixProtocol)) {
            Assertions.assertTrue((boolean)TLS.isSecure((String)protocol));
        }
    }

    @Test
    void testParseBasic() throws Exception {
        MatcherAssert.assertThat((Object)TLS.parse((String)"TLSv1"), (Matcher)CoreMatchers.equalTo((Object)TLS.V_1_0.getVersion()));
        MatcherAssert.assertThat((Object)TLS.parse((String)"TLSv1.1"), (Matcher)CoreMatchers.equalTo((Object)TLS.V_1_1.getVersion()));
        MatcherAssert.assertThat((Object)TLS.parse((String)"TLSv1.2"), (Matcher)CoreMatchers.equalTo((Object)TLS.V_1_2.getVersion()));
        MatcherAssert.assertThat((Object)TLS.parse((String)"TLSv1.3  "), (Matcher)CoreMatchers.equalTo((Object)TLS.V_1_3.getVersion()));
        MatcherAssert.assertThat((Object)TLS.parse((String)"TLSv22.356"), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("TLS", 22, 356)));
    }

    @Test
    void testParseBuffer() throws Exception {
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(1, 13);
        MatcherAssert.assertThat((Object)TLS.parse((CharSequence)" TLSv1.2,0000", (Tokenizer.Cursor)cursor, (Tokenizer.Delimiter)Tokenizer.delimiters((char)',')), (Matcher)CoreMatchers.equalTo((Object)TLS.V_1_2.getVersion()));
        MatcherAssert.assertThat((Object)cursor.getPos(), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    void testParseFailure() {
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"Tlsv1"));
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"TLSV1"));
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"TLSv"));
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"TLSv1A"));
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"TLSv1.A"));
        Assertions.assertThrows(ParseException.class, () -> TLS.parse((String)"TLSv1.1 huh?"));
    }
}

