/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.batchee.container.services.persistence.jpa.domain;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import org.apache.batchee.container.util.ExceptionUtil;

/**
 * Small helper class to transform java.util.Properties into a String
 * and vice versa
 */
public class PropertyHelper {

    private PropertyHelper() {
        // private utility class ct
    }

    public static Properties stringToProperties(String val) {
        Properties props = new Properties();
        if (val != null) {
            StringReader stringReader = new StringReader(val);
            try {
                props.load(stringReader);
            } catch (IOException e) {
                ExceptionUtil.throwAsRuntimeException(e);
            }
        }

        return props;
    }

    public static String propertiesToString(Properties props) {
        if (props == null || props.isEmpty()) {
            return null;
        }

        StringWriter stringWriter = new StringWriter();
        try {
            props.store(stringWriter, null);
        } catch (Exception e) {
            ExceptionUtil.throwAsRuntimeException(e);
        }

        return stringWriter.toString();
    }
}
