/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifEOFPart;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifVersionLine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class LdifDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private ILdifEditor editor;
    private Map<String, Object> textAttributeKeyToValueMap;

    public LdifDamagerRepairer(ILdifEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        LdifFile ldifModel = this.editor.getLdifModel();
        List allContainers = ldifModel.getContainers();
        ArrayList<LdifContainer> containerList = new ArrayList<LdifContainer>();
        for (LdifContainer ldifContainer : allContainers) {
            Region containerRegion = new Region(ldifContainer.getOffset(), ldifContainer.getLength());
            if (!TextUtilities.overlaps((IRegion)containerRegion, (IRegion)damage)) continue;
            containerList.add(ldifContainer);
        }
        LdifContainer[] containers = containerList.toArray(new LdifContainer[containerList.size()]);
        this.highlight(containers, presentation, damage);
    }

    private TextAttribute getTextAttribute(String key) {
        boolean isDefaultDefaultKey;
        IPreferenceStore store = LdifEditorActivator.getDefault().getPreferenceStore();
        String colorKey = String.valueOf(key) + "_RGB";
        String styleKey = String.valueOf(key) + "_STYLE";
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)colorKey);
        int style = store.getInt(styleKey);
        if (this.textAttributeKeyToValueMap != null) {
            if (this.textAttributeKeyToValueMap.containsKey(colorKey)) {
                rgb = (RGB)this.textAttributeKeyToValueMap.get(colorKey);
            }
            if (this.textAttributeKeyToValueMap.containsKey(styleKey)) {
                style = (Integer)this.textAttributeKeyToValueMap.get(styleKey);
            }
        }
        Color color = (isDefaultDefaultKey = "".equals(store.getString(colorKey))) ? null : LdifEditorActivator.getDefault().getColor(rgb);
        TextAttribute textAttribute = new TextAttribute(color, null, style);
        return textAttribute;
    }

    public void setTextAttribute(String key, RGB rgb, int style) {
        if (this.textAttributeKeyToValueMap == null) {
            this.textAttributeKeyToValueMap = new HashMap<String, Object>();
        }
        this.textAttributeKeyToValueMap.put(String.valueOf(key) + "_RGB", rgb);
        this.textAttributeKeyToValueMap.put(String.valueOf(key) + "_STYLE", new Integer(style));
    }

    private void highlight(LdifContainer[] containers, TextPresentation presentation, ITypedRegion damage) {
        TextAttribute COMMENT_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxComment");
        TextAttribute KEYWORD_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxKeyword");
        TextAttribute DN_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxDn");
        TextAttribute ATTRIBUTE_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxAttribute");
        TextAttribute VALUETYPE_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxValueType");
        TextAttribute VALUE_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxValue");
        TextAttribute ADD_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxChangetypeAdd");
        TextAttribute MODIFY_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxChangetypeModify");
        TextAttribute DELETE_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxChangetypeDelete");
        TextAttribute MODDN_TEXT_ATTRIBUTE = this.getTextAttribute("ldifEditorSyntaxChangetypeModdn");
        int z = 0;
        while (z < containers.length) {
            LdifContainer container = containers[z];
            LdifPart[] parts = container.getParts();
            int i = 0;
            while (i < parts.length) {
                int offset = parts[i].getOffset();
                if (parts[i] instanceof LdifLineBase) {
                    int valueTypeLength;
                    LdifLineBase line = (LdifLineBase)parts[i];
                    if (line instanceof LdifVersionLine) {
                        this.addStyleRange(presentation, offset, line.getLength(), KEYWORD_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifCommentLine) {
                        this.addStyleRange(presentation, offset, line.getLength(), COMMENT_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifDnLine) {
                        LdifDnLine dnLine = (LdifDnLine)line;
                        int dnSpecLength = dnLine.getRawDnSpec().length();
                        valueTypeLength = dnLine.getRawValueType().length();
                        int dnLength = dnLine.getRawDn().length();
                        this.addStyleRange(presentation, offset, dnSpecLength, DN_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + dnSpecLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + dnSpecLength + valueTypeLength, dnLength, DN_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifAttrValLine) {
                        LdifAttrValLine attrValLine = (LdifAttrValLine)line;
                        int attributeNameLength = attrValLine.getRawAttributeDescription().length();
                        valueTypeLength = attrValLine.getRawValueType().length();
                        int valueLength = attrValLine.getRawValue().length();
                        this.addStyleRange(presentation, offset, attributeNameLength, ATTRIBUTE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + attributeNameLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + attributeNameLength + valueTypeLength, valueLength, VALUE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifChangeTypeLine) {
                        LdifChangeTypeLine changeTypeLine = (LdifChangeTypeLine)line;
                        int changeTypeSpecLength = changeTypeLine.getRawChangeTypeSpec().length();
                        valueTypeLength = changeTypeLine.getRawValueType().length();
                        int changeTypeLength = changeTypeLine.getRawChangeType().length();
                        this.addStyleRange(presentation, offset, changeTypeSpecLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + changeTypeSpecLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        if (container instanceof LdifChangeAddRecord) {
                            this.addStyleRange(presentation, offset + changeTypeSpecLength + valueTypeLength, changeTypeLength, ADD_TEXT_ATTRIBUTE);
                        } else if (container instanceof LdifChangeModifyRecord) {
                            this.addStyleRange(presentation, offset + changeTypeSpecLength + valueTypeLength, changeTypeLength, MODIFY_TEXT_ATTRIBUTE);
                        } else if (container instanceof LdifChangeModDnRecord) {
                            this.addStyleRange(presentation, offset + changeTypeSpecLength + valueTypeLength, changeTypeLength, MODDN_TEXT_ATTRIBUTE);
                        } else if (container instanceof LdifChangeDeleteRecord) {
                            this.addStyleRange(presentation, offset + changeTypeSpecLength + valueTypeLength, changeTypeLength, DELETE_TEXT_ATTRIBUTE);
                        }
                    } else if (line instanceof LdifNewrdnLine) {
                        LdifNewrdnLine newrdnLine = (LdifNewrdnLine)line;
                        int newrdnSpecLength = newrdnLine.getRawNewrdnSpec().length();
                        valueTypeLength = newrdnLine.getRawValueType().length();
                        int newrdnLength = newrdnLine.getRawNewrdn().length();
                        this.addStyleRange(presentation, offset, newrdnSpecLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + newrdnSpecLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + newrdnSpecLength + valueTypeLength, newrdnLength, VALUE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifDeloldrdnLine) {
                        LdifDeloldrdnLine deleteoldrdnLine = (LdifDeloldrdnLine)line;
                        int deleteoldrdnSpecLength = deleteoldrdnLine.getRawDeleteOldrdnSpec().length();
                        valueTypeLength = deleteoldrdnLine.getRawValueType().length();
                        int deleteoldrdnLength = deleteoldrdnLine.getRawDeleteOldrdn().length();
                        this.addStyleRange(presentation, offset, deleteoldrdnSpecLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + deleteoldrdnSpecLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + deleteoldrdnSpecLength + valueTypeLength, deleteoldrdnLength, VALUE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifNewsuperiorLine) {
                        LdifNewsuperiorLine newsuperiorLine = (LdifNewsuperiorLine)line;
                        int newsuperiorSpecLength = newsuperiorLine.getRawNewSuperiorSpec().length();
                        valueTypeLength = newsuperiorLine.getRawValueType().length();
                        int newsuperiorLength = newsuperiorLine.getRawNewSuperiorDn().length();
                        this.addStyleRange(presentation, offset, newsuperiorSpecLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + newsuperiorSpecLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + newsuperiorSpecLength + valueTypeLength, newsuperiorLength, VALUE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifModSpecTypeLine) {
                        LdifModSpecTypeLine modSpecTypeLine = (LdifModSpecTypeLine)line;
                        int modTypeLength = modSpecTypeLine.getRawModType().length();
                        valueTypeLength = modSpecTypeLine.getRawValueType().length();
                        int attributeDescriptionLength = modSpecTypeLine.getRawAttributeDescription().length();
                        this.addStyleRange(presentation, offset, modTypeLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + modTypeLength, valueTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + modTypeLength + valueTypeLength, attributeDescriptionLength, ATTRIBUTE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifModSpecSepLine) {
                        this.addStyleRange(presentation, offset, line.getLength(), VALUETYPE_TEXT_ATTRIBUTE);
                    } else if (line instanceof LdifControlLine) {
                        LdifControlLine controlLine = (LdifControlLine)line;
                        int controlSpecLength = controlLine.getRawControlSpec().length();
                        int controlTypeLength = controlLine.getRawControlType().length();
                        int oidLength = controlLine.getRawOid().length();
                        int critLength = controlLine.getRawCriticality().length();
                        int valueTypeLength2 = controlLine.getRawControlValueType().length();
                        int valueLength = controlLine.getRawControlValue().length();
                        this.addStyleRange(presentation, offset, controlSpecLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + controlSpecLength, controlTypeLength, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + controlSpecLength + controlTypeLength, oidLength, ATTRIBUTE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + controlSpecLength + controlTypeLength + oidLength, critLength, KEYWORD_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + controlSpecLength + controlTypeLength + oidLength + critLength, valueTypeLength2, VALUETYPE_TEXT_ATTRIBUTE);
                        this.addStyleRange(presentation, offset + controlSpecLength + controlTypeLength + oidLength + critLength + valueTypeLength2, valueLength, VALUE_TEXT_ATTRIBUTE);
                    }
                } else if (parts[i] instanceof LdifModSpec) {
                    LdifModSpec modSpec = (LdifModSpec)parts[i];
                    this.highlight(new LdifContainer[]{modSpec}, presentation, damage);
                } else if (!(parts[i] instanceof LdifInvalidPart) && !(parts[i] instanceof LdifEOFPart)) {
                    System.out.println("LdifDamagerRepairer: Unspecified Token: " + parts[i].getClass());
                }
                ++i;
            }
            ++z;
        }
    }

    private void addStyleRange(TextPresentation presentation, int offset, int length, TextAttribute textAttribute) {
        if (offset >= 0 && length > 0) {
            StyleRange range = new StyleRange(offset, length, textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle() & 3);
            range.underline = (textAttribute.getStyle() & 0x40000000) != 0;
            range.strikeout = (textAttribute.getStyle() & 0x20000000) != 0;
            presentation.addStyleRange(range);
        }
    }
}

