/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialogValueEditor
extends CellEditor
implements IValueEditor {
    private Object value;
    private Shell shell;
    private String name;
    private ImageDescriptor imageDescriptor;

    protected AbstractDialogValueEditor() {
    }

    protected boolean showRawValues() {
        return BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues");
    }

    @Override
    public CellEditor getCellEditor() {
        return this;
    }

    protected final Control createControl(Composite parent) {
        this.shell = parent.getShell();
        return null;
    }

    protected final void doSetFocus() {
    }

    protected final Object doGetValue() {
        return this.value;
    }

    protected final void doSetValue(Object value) {
        if (value instanceof IValue.EmptyValue) {
            IValue.EmptyValue emptyValue = (IValue.EmptyValue)value;
            value = emptyValue.isBinary() ? (Object)emptyValue.getBinaryValue() : emptyValue.getStringValue();
        }
        this.value = value;
    }

    public final void activate() {
        boolean save = this.openDialog(this.shell);
        if (!save || this.value == null) {
            this.value = null;
            this.fireCancelEditor();
        } else {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    protected abstract boolean openDialog(Shell var1);

    protected abstract Object getEmptyRawValue(IAttribute var1);

    @Override
    public String getDisplayValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        ArrayList<IValue> valueList = new ArrayList<IValue>();
        for (IAttribute attribute : attributeHierarchy) {
            valueList.addAll(Arrays.asList(attribute.getValues()));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = valueList.iterator();
        while (it.hasNext()) {
            IValue value = (IValue)it.next();
            sb.append(this.getDisplayValue(value));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return null;
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 0) {
            return this.getEmptyRawValue(attributeHierarchy.getAttribute());
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 1) {
            return this.getRawValue(attributeHierarchy.getAttribute().getValues()[0]);
        }
        return null;
    }

    @Override
    public boolean hasValue(IValue value) {
        return value != null && (value.isString() || value.isBinary());
    }

    @Override
    public void setValueEditorName(String name) {
        this.name = name;
    }

    @Override
    public String getValueEditorName() {
        return this.name;
    }

    @Override
    public void setValueEditorImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public ImageDescriptor getValueEditorImageDescriptor() {
        return this.imageDescriptor;
    }
}

